/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import com.google.inject.Inject;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProviderAware;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.Persistor;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.isis.PersistenceSessionProvider;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class PanelAbstract<T extends IModel<?>>
extends Panel
implements IHeaderContributor,
PersistenceSessionProvider,
AuthenticationSessionProvider {
    private static final long serialVersionUID = 1L;
    private ComponentType componentType;
    @javax.inject.Inject
    @Inject
    private ComponentFactoryRegistry componentFactoryRegistry;

    public PanelAbstract(ComponentType componentType) {
        this(componentType, null);
    }

    public PanelAbstract(String id) {
        this(id, null);
    }

    public PanelAbstract(ComponentType componentType, T model) {
        this(componentType.getWicketId(), model);
    }

    public PanelAbstract(String id, T model) {
        super(id, model);
        this.componentType = ComponentType.lookup(id);
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public T getModel() {
        return (T)this.getDefaultModel();
    }

    protected Component addOrReplace(ComponentType componentType, IModel<?> model) {
        return this.componentFactoryRegistry.addOrReplaceComponent((MarkupContainer)this, componentType, model);
    }

    protected void permanentlyHide(ComponentType ... componentIds) {
        Components.permanentlyHide((MarkupContainer)this, componentIds);
    }

    public void permanentlyHide(String ... ids) {
        Components.permanentlyHide((MarkupContainer)this, ids);
    }

    public void renderHead(IHeaderResponse response) {
        PanelUtil.renderHead(response, ((Object)((Object)this)).getClass());
    }

    public UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this);
    }

    public AuthenticationSession getAuthenticationSession() {
        AuthenticationSessionProvider asa = (AuthenticationSessionProvider)Session.get();
        return asa.getAuthenticationSession();
    }

    public IsisContext getIsisContext() {
        return IsisContext.getInstance();
    }

    public Persistor getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    public AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }

    protected List<ObjectAdapter> getServiceAdapters() {
        return IsisContext.getPersistenceSession().getServices();
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        return this.componentFactoryRegistry;
    }

    @Inject
    public void setComponentFactoryRegistry(ComponentFactoryRegistry componentFactoryRegistry) {
        this.componentFactoryRegistry = componentFactoryRegistry;
    }

    public void injectInto(Object candidate) {
        if (AuthenticationSessionProviderAware.class.isAssignableFrom(candidate.getClass())) {
            AuthenticationSessionProviderAware cast = (AuthenticationSessionProviderAware)AuthenticationSessionProviderAware.class.cast(candidate);
            cast.setAuthenticationSessionProvider((AuthenticationSessionProvider)this);
        }
    }
}

