/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import com.google.common.base.Strings;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public final class PanelUtil {
    private PanelUtil() {
    }

    public static void renderHead(IHeaderResponse response, Class<?> cls) {
        CssResourceReference cssResourceReference = PanelUtil.cssResourceReferenceFor(cls);
        if (cssResourceReference == null) {
            return;
        }
        CssReferenceHeaderItem forReference = CssHeaderItem.forReference((ResourceReference)cssResourceReference);
        response.render((HeaderItem)forReference);
    }

    public static CssResourceReference cssResourceReferenceFor(Class<?> cls) {
        return PanelUtil.cssResourceReferenceFor(cls, null);
    }

    public static CssResourceReference cssResourceReferenceFor(Class<?> cls, String suffix) {
        String url = PanelUtil.cssFor(cls, suffix);
        if (url == null) {
            return null;
        }
        return new CssResourceReference(cls, url);
    }

    private static String cssFor(Class<?> cls, String suffix) {
        if (cls == null) {
            return null;
        }
        String simpleName = cls.getSimpleName();
        if (Strings.isNullOrEmpty((String)simpleName)) {
            return null;
        }
        String string = suffix != null ? "-" + suffix : "";
        return simpleName + string + ".css";
    }
}

