/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.selector.links;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.hints.UiHintPathSignificant;
import org.apache.isis.viewer.wicket.model.hints.UiHintsSetEvent;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.links.LinksProvider;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.additionallinks.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.unresolved.CollectionContentsAsUnresolvedPanelFactory;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class LinksSelectorPanelAbstract<T extends IModel<?>>
extends PanelAbstract<T>
implements UiHintPathSignificant {
    private static final long serialVersionUID = 1L;
    private static final String INVISIBLE_CLASS = "link-selector-panel-invisible";
    private static final int MAX_NUM_UNDERLYING_VIEWS = 10;
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    public static final String ID_ADDITIONAL_LINK = "additionalLink";
    private static final String ID_VIEWS = "views";
    private static final String ID_VIEW_LIST = "viewList";
    private static final String ID_VIEW_LINK = "viewLink";
    private static final String ID_VIEW_ITEM = "viewItem";
    private static final String ID_VIEW_TITLE = "viewTitle";
    private static final String UIHINT_VIEW = "view";
    private final ComponentType componentType;
    private final String underlyingIdPrefix;
    private ComponentFactory selectedComponentFactory;
    protected Component selectedComponent;
    protected WebMarkupContainer additionalLinks;

    public LinksSelectorPanelAbstract(String id, String underlyingIdPrefix, T model, ComponentFactory factory) {
        super(id, model);
        this.underlyingIdPrefix = underlyingIdPrefix;
        this.componentType = factory.getComponentType();
    }

    public void onInitialize() {
        super.onInitialize();
        ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactoryElseFailFast(this.getComponentType(), (IModel<?>)this.getModel());
        this.addAdditionalLinks(this.getModel());
        this.addUnderlyingViews(this.underlyingIdPrefix, this.getModel(), componentFactory);
    }

    protected void addAdditionalLinks(T model) {
        if (!(model instanceof LinksProvider)) {
            this.permanentlyHide(ID_ADDITIONAL_LINKS);
            return;
        }
        LinksProvider linksProvider = (LinksProvider)model;
        List links = linksProvider.getLinks();
        this.addAdditionalLinks((MarkupContainer)this, links);
    }

    protected void addAdditionalLinks(MarkupContainer markupContainer, List<LinkAndLabel> links) {
        if (links == null || links.isEmpty()) {
            Components.permanentlyHide(markupContainer, ID_ADDITIONAL_LINKS);
            return;
        }
        links = Lists.newArrayList(links);
        this.additionalLinks = new AdditionalLinksPanel(ID_ADDITIONAL_LINKS, links);
        markupContainer.addOrReplace(new Component[]{this.additionalLinks});
    }

    private void addUnderlyingViews(String underlyingIdPrefix, final T model, ComponentFactory factory) {
        List<ComponentFactory> componentFactories = this.findOtherComponentFactories(model, factory);
        int selected = this.honourViewHintElseDefault(componentFactories, (IModel<?>)model);
        final LinksSelectorPanelAbstract selectorPanel = this;
        final Component[] underlyingViews = new Component[10];
        int i = 0;
        T emptyModel = this.dummyOf(model);
        for (ComponentFactory componentFactory : componentFactories) {
            String underlyingId = underlyingIdPrefix + "-" + i;
            Component underlyingView = componentFactory.createComponent(underlyingId, (IModel<?>)(i == selected ? model : emptyModel));
            underlyingViews[i++] = underlyingView;
            selectorPanel.addOrReplace(new Component[]{underlyingView});
        }
        while (i < 10) {
            String underlyingId = underlyingIdPrefix + "-" + i;
            this.permanentlyHide(underlyingId);
            ++i;
        }
        if (componentFactories.size() <= 1) {
            this.permanentlyHide(ID_VIEWS);
        } else {
            Model componentFactoryModel = new Model();
            selectorPanel.selectedComponentFactory = componentFactories.get(selected);
            componentFactoryModel.setObject((Serializable)selectorPanel.selectedComponentFactory);
            final WebMarkupContainer views = new WebMarkupContainer(ID_VIEWS);
            WebMarkupContainer container = new WebMarkupContainer(ID_VIEW_LIST);
            views.addOrReplace(new Component[]{container});
            views.setOutputMarkupId(true);
            this.setOutputMarkupId(true);
            ListView<ComponentFactory> listView = new ListView<ComponentFactory>(ID_VIEW_ITEM, componentFactories){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<ComponentFactory> item) {
                    final int underlyingViewNum = item.getIndex();
                    final ComponentFactory componentFactory = (ComponentFactory)item.getModelObject();
                    AjaxLink<Void> link = new AjaxLink<Void>(LinksSelectorPanelAbstract.ID_VIEW_LINK){
                        private static final long serialVersionUID = 1L;

                        public void onClick(AjaxRequestTarget target) {
                            LinksSelectorPanelAbstract linksSelectorPanel = LinksSelectorPanelAbstract.this;
                            linksSelectorPanel.setViewHintAndBroadcast(underlyingViewNum, target);
                            IModel dummyModel = LinksSelectorPanelAbstract.this.dummyOf(model);
                            for (int i = 0; i < 10; ++i) {
                                Component component = underlyingViews[i];
                                if (component == null) continue;
                                boolean isSelected = i == underlyingViewNum;
                                LinksSelectorPanelAbstract.applyCssVisibility(component, isSelected);
                                component.setDefaultModel(isSelected ? model : dummyModel);
                            }
                            selectorPanel.selectedComponentFactory = componentFactory;
                            selectorPanel.selectedComponent = underlyingViews[underlyingViewNum];
                            selectorPanel.onSelect(target);
                            target.add(new Component[]{selectorPanel, views});
                        }
                    };
                    String name = this.nameFor(componentFactory);
                    Label viewTitleLabel = new Label(LinksSelectorPanelAbstract.ID_VIEW_TITLE, name);
                    viewTitleLabel.add(new Behavior[]{new CssClassAppender(StringExtensions.asLowerDashed((String)name))});
                    link.add(new Component[]{viewTitleLabel});
                    item.add(new Component[]{link});
                    link.setEnabled(componentFactory != selectorPanel.selectedComponentFactory);
                }

                private String nameFor(ComponentFactory componentFactory) {
                    return componentFactory instanceof CollectionContentsAsUnresolvedPanelFactory ? "hide" : componentFactory.getName();
                }
            };
            container.add(new Component[]{listView});
            this.addOrReplace(new Component[]{views});
        }
        for (i = 0; i < 10; ++i) {
            Component component = underlyingViews[i];
            if (component == null) continue;
            if (i != selected) {
                component.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)" link-selector-panel-invisible"))});
                continue;
            }
            this.selectedComponent = component;
        }
    }

    protected void setViewHintAndBroadcast(int viewNum, AjaxRequestTarget target) {
        UiHintContainer uiHintContainer = this.getUiHintContainer();
        if (uiHintContainer == null) {
            return;
        }
        uiHintContainer.setHint((Component)this, UIHINT_VIEW, "" + viewNum);
        this.send((IEventSink)this.getPage(), Broadcast.EXACT, new UiHintsSetEvent(uiHintContainer, target));
    }

    protected void onSelect(AjaxRequestTarget target) {
    }

    protected abstract T dummyOf(T var1);

    protected static void applyCssVisibility(Component component, boolean visible) {
        if (component == null) {
            return;
        }
        AttributeModifier modifier = visible ? new AttributeModifier("class", (Serializable)((Object)String.valueOf(component.getMarkupAttributes().get((Object)"class")).replaceFirst(INVISIBLE_CLASS, ""))) : new AttributeAppender("class", (Serializable)((Object)" link-selector-panel-invisible"));
        component.add(new Behavior[]{modifier});
    }

    protected int honourViewHintElseDefault(List<ComponentFactory> componentFactories, IModel<?> model) {
        String viewStr;
        UiHintContainer hintContainer = this.getUiHintContainer();
        if (hintContainer != null && (viewStr = hintContainer.getHint((Component)this, UIHINT_VIEW)) != null) {
            try {
                int view = Integer.parseInt(viewStr);
                if (view >= 0 && view < componentFactories.size()) {
                    return view;
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        int initialFactory = this.determineInitialFactory(componentFactories, model);
        if (hintContainer != null) {
            hintContainer.setHint((Component)this, UIHINT_VIEW, "" + initialFactory);
        }
        return initialFactory;
    }

    protected abstract int determineInitialFactory(List<ComponentFactory> var1, IModel<?> var2);

    private List<ComponentFactory> findOtherComponentFactories(T model, final ComponentFactory ignoreFactory) {
        List<ComponentFactory> componentFactories = this.getComponentFactoryRegistry().findComponentFactories(this.componentType, (IModel<?>)model);
        ArrayList otherFactories = Lists.newArrayList((Iterable)Collections2.filter(componentFactories, (Predicate)new Predicate<ComponentFactory>(){

            public boolean apply(ComponentFactory input) {
                return input != ignoreFactory;
            }
        }));
        return this.ordered(otherFactories);
    }

    protected List<ComponentFactory> ordered(List<ComponentFactory> otherFactories) {
        return otherFactories;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        PanelUtil.renderHead(response, LinksSelectorPanelAbstract.class);
    }
}

