/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;

public final class Components {
    private Components() {
    }

    public static void permanentlyHide(MarkupContainer container, String ... ids) {
        for (String id : ids) {
            Components.permanentlyHideSingle(container, id);
        }
    }

    public static void permanentlyHide(MarkupContainer container, ComponentType ... componentIds) {
        for (ComponentType componentType : componentIds) {
            String wicketId = componentType.getWicketId();
            Components.permanentlyHideSingle(container, wicketId);
        }
    }

    private static void permanentlyHideSingle(MarkupContainer container, String id) {
        Label label = new Label(id, "");
        label.setVisible(false);
        container.addOrReplace(new Component[]{label});
    }

    public static void setVisible(MarkupContainer container, boolean visibility, String ... ids) {
        for (String id : ids) {
            Components.setVisible(container, visibility, id);
        }
    }

    public static void setVisible(MarkupContainer container, boolean visibility, ComponentType ... componentTypes) {
        for (ComponentType componentType : componentTypes) {
            String wicketId = componentType.getWicketId();
            Components.setVisible(container, visibility, wicketId);
        }
    }

    private static void setVisible(MarkupContainer container, boolean visibility, String wicketId) {
        Component childComponent = container.get(wicketId);
        childComponent.setVisible(visibility);
    }
}

