/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.ResultSetWrapper;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.apache.jackrabbit.data.core.TransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHelper {
    static Logger log = LoggerFactory.getLogger(ConnectionHelper.class);
    private static final int RETRIES = 1;
    private static final int SLEEP_BETWEEN_RETRIES_MS = 100;
    final boolean blockOnConnectionLoss;
    private final boolean checkTablesWithUserName;
    protected final DataSource dataSource;
    private Map<Object, Connection> batchConnectionMap = Collections.synchronizedMap(new HashMap());
    private int fetchSize = 0;

    public ConnectionHelper(DataSource dataSrc, boolean block) {
        this.dataSource = dataSrc;
        this.checkTablesWithUserName = false;
        this.blockOnConnectionLoss = block;
    }

    protected ConnectionHelper(DataSource dataSrc, boolean checkWithUserName, boolean block) {
        this.dataSource = dataSrc;
        this.checkTablesWithUserName = checkWithUserName;
        this.blockOnConnectionLoss = block;
    }

    protected ConnectionHelper(DataSource dataSrc, boolean checkWithUserName, boolean block, int fetchSize) {
        this.dataSource = dataSrc;
        this.checkTablesWithUserName = checkWithUserName;
        this.blockOnConnectionLoss = block;
        this.fetchSize = fetchSize;
    }

    public final String prepareDbIdentifier(String identifier) throws SQLException {
        if (identifier == null) {
            return null;
        }
        String legalChars = "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        legalChars = legalChars + this.getExtraNameCharacters();
        String id = identifier.toUpperCase();
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                this.replaceCharacter(escaped, c);
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    protected void replaceCharacter(StringBuilder escaped, char c) {
        escaped.append("_x");
        String hex = Integer.toHexString(c);
        escaped.append("0000".toCharArray(), 0, 4 - hex.length());
        escaped.append(hex);
        escaped.append("_");
    }

    protected boolean inBatchMode() {
        return this.getTransactionAwareBatchConnection() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExtraNameCharacters() throws SQLException {
        Connection con = this.dataSource.getConnection();
        try {
            DatabaseMetaData metaData = con.getMetaData();
            String string = metaData.getExtraNameCharacters();
            return string;
        }
        finally {
            DbUtility.close(con, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tableExists(String tableName) throws SQLException {
        Connection con = this.dataSource.getConnection();
        ResultSet rs = null;
        boolean schemaExists = false;
        String name = tableName;
        try {
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData.storesLowerCaseIdentifiers()) {
                name = tableName.toLowerCase();
            } else if (metaData.storesUpperCaseIdentifiers()) {
                name = tableName.toUpperCase();
            }
            String userName = null;
            if (this.checkTablesWithUserName) {
                userName = metaData.getUserName();
            }
            rs = metaData.getTables(null, userName, name, null);
            schemaExists = rs.next();
        }
        catch (Throwable throwable) {
            DbUtility.close(con, null, rs);
            throw throwable;
        }
        DbUtility.close(con, null, rs);
        return schemaExists;
    }

    public final void startBatch() throws SQLException {
        if (this.inBatchMode()) {
            throw new SQLException("already in batch mode");
        }
        Connection batchConnection = null;
        try {
            batchConnection = this.getConnection(false);
            batchConnection.setAutoCommit(false);
            this.setTransactionAwareBatchConnection(batchConnection);
        }
        catch (SQLException e) {
            this.removeTransactionAwareBatchConnection();
            if (batchConnection != null) {
                DbUtility.close(batchConnection, null, null);
            }
            throw e;
        }
    }

    public final void endBatch(boolean commit) throws SQLException {
        if (!this.inBatchMode()) {
            throw new SQLException("not in batch mode");
        }
        Connection batchConnection = this.getTransactionAwareBatchConnection();
        try {
            if (commit) {
                batchConnection.commit();
            } else {
                batchConnection.rollback();
            }
        }
        finally {
            this.removeTransactionAwareBatchConnection();
            if (batchConnection != null) {
                DbUtility.close(batchConnection, null, null);
            }
        }
    }

    public final void exec(final String sql, final Object ... params) throws SQLException {
        new RetryManager<Void>(params){

            @Override
            protected Void call() throws SQLException {
                ConnectionHelper.this.reallyExec(sql, params);
                return null;
            }
        }.doTry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reallyExec(String sql, Object ... params) throws SQLException {
        Connection con = null;
        Statement stmt = null;
        boolean inBatchMode = this.inBatchMode();
        try {
            con = this.getConnection(inBatchMode);
            if (params == null || params.length == 0) {
                stmt = con.createStatement();
                stmt.execute(sql);
            } else {
                PreparedStatement p = con.prepareStatement(sql);
                stmt = p;
                this.execute(p, params);
            }
            this.closeResources(con, stmt, null, inBatchMode);
        }
        catch (Throwable throwable) {
            this.closeResources(con, stmt, null, inBatchMode);
            throw throwable;
        }
    }

    public final int update(final String sql, final Object ... params) throws SQLException {
        return (Integer)new RetryManager<Integer>(params){

            @Override
            protected Integer call() throws SQLException {
                return ConnectionHelper.this.reallyUpdate(sql, params);
            }
        }.doTry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int reallyUpdate(String sql, Object ... params) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        boolean inBatchMode = this.inBatchMode();
        try {
            con = this.getConnection(inBatchMode);
            stmt = con.prepareStatement(sql);
            int n = this.execute(stmt, params).getUpdateCount();
            return n;
        }
        finally {
            this.closeResources(con, stmt, null, inBatchMode);
        }
    }

    public final ResultSet query(String sql, Object ... params) throws SQLException {
        return this.exec(sql, params, false, 0);
    }

    public final ResultSet exec(final String sql, final Object[] params, final boolean returnGeneratedKeys, final int maxRows) throws SQLException {
        return (ResultSet)new RetryManager<ResultSet>(params){

            @Override
            protected ResultSet call() throws SQLException {
                return ConnectionHelper.this.reallyExec(sql, params, returnGeneratedKeys, maxRows);
            }
        }.doTry();
    }

    ResultSet reallyExec(String sql, Object[] params, boolean returnGeneratedKeys, int maxRows) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean inBatchMode = this.inBatchMode();
        try {
            con = this.getConnection(inBatchMode);
            stmt = returnGeneratedKeys ? con.prepareStatement(sql, 1) : con.prepareStatement(sql);
            stmt.setMaxRows(maxRows);
            int currentFetchSize = this.fetchSize;
            if (0 < maxRows && maxRows < currentFetchSize) {
                currentFetchSize = maxRows;
            }
            stmt.setFetchSize(currentFetchSize);
            this.execute(stmt, params);
            rs = returnGeneratedKeys ? stmt.getGeneratedKeys() : stmt.getResultSet();
            if (rs == null) {
                this.closeResources(con, stmt, rs, inBatchMode);
                return null;
            }
            if (inBatchMode) {
                return ResultSetWrapper.newInstance(null, stmt, rs);
            }
            return ResultSetWrapper.newInstance(con, stmt, rs);
        }
        catch (SQLException e) {
            this.closeResources(con, stmt, rs, inBatchMode);
            throw e;
        }
    }

    protected final Connection getConnection(boolean inBatchMode) throws SQLException {
        if (inBatchMode) {
            return this.getTransactionAwareBatchConnection();
        }
        Connection con = this.dataSource.getConnection();
        if (!con.getAutoCommit()) {
            con.setAutoCommit(true);
        }
        return con;
    }

    private Connection getTransactionAwareBatchConnection() {
        Object threadId = TransactionContext.getCurrentThreadId();
        return this.batchConnectionMap.get(threadId);
    }

    private void setTransactionAwareBatchConnection(Connection batchConnection) {
        Object threadId = TransactionContext.getCurrentThreadId();
        this.batchConnectionMap.put(threadId, batchConnection);
    }

    private void removeTransactionAwareBatchConnection() {
        Object threadId = TransactionContext.getCurrentThreadId();
        this.batchConnectionMap.remove(threadId);
    }

    protected final void closeResources(Connection con, Statement stmt, ResultSet rs, boolean inBatchMode) {
        if (inBatchMode) {
            DbUtility.close(null, stmt, rs);
        } else {
            DbUtility.close(con, stmt, rs);
        }
    }

    protected PreparedStatement execute(PreparedStatement stmt, Object[] params) throws SQLException {
        for (int i = 0; params != null && i < params.length; ++i) {
            Object p = params[i];
            if (p instanceof StreamWrapper) {
                StreamWrapper wrapper = (StreamWrapper)p;
                stmt.setBinaryStream(i + 1, wrapper.getStream(), (int)wrapper.getSize());
                continue;
            }
            stmt.setObject(i + 1, p);
        }
        stmt.execute();
        return stmt;
    }

    public abstract class RetryManager<T> {
        private Object[] params;

        public RetryManager(Object[] params) {
            this.params = params;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final T doTry() throws SQLException {
            try {
                if (ConnectionHelper.this.inBatchMode()) {
                    T t = this.call();
                    return t;
                }
                boolean sleepInterrupted = false;
                int failures = 0;
                SQLException lastException = null;
                while (!sleepInterrupted && (ConnectionHelper.this.blockOnConnectionLoss || failures <= 1)) {
                    T t;
                    try {
                        t = this.call();
                    }
                    catch (SQLException e) {
                        try {
                            lastException = e;
                            log.error("Failed to execute SQL (stacktrace on DEBUG log level): " + lastException);
                            log.debug("Failed to execute SQL", (Throwable)lastException);
                            if (!this.resetParamResources()) {
                                log.warn("Could not reset parameters: not retrying SQL call");
                                throw lastException;
                            }
                            if (!ConnectionHelper.this.blockOnConnectionLoss && ++failures > 1) continue;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                                sleepInterrupted = true;
                                log.error("Interrupted: canceling retry");
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            throw lastException;
                        }
                    }
                    return t;
                }
            }
            finally {
                this.cleanupParamResources();
            }
        }

        protected abstract T call() throws SQLException;

        protected void cleanupParamResources() {
            for (int i = 0; this.params != null && i < this.params.length; ++i) {
                Object p = this.params[i];
                if (!(p instanceof StreamWrapper)) continue;
                StreamWrapper wrapper = (StreamWrapper)p;
                wrapper.closeStream();
            }
        }

        protected boolean resetParamResources() {
            for (int i = 0; this.params != null && i < this.params.length; ++i) {
                StreamWrapper wrapper;
                Object p = this.params[i];
                if (!(p instanceof StreamWrapper) || (wrapper = (StreamWrapper)p).resetStream()) continue;
                return false;
            }
            return true;
        }
    }
}

