/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import org.apache.jackrabbit.test.XMLChar;

public class EscapeJCRUtil {
    private static final String utf16esc = "_x[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]_";
    private static char[] Utf16Padding = new char[]{'0', '0', '0'};
    private static int utf16length = 4;

    public static String escapeJCRValues(String str) {
        return EscapeJCRUtil.escapeValues(str);
    }

    public static String escapeJCRNames(String str) {
        return EscapeJCRUtil.escapeNames(str);
    }

    private static String escapeNames(String str) {
        String[] split = str.split(":");
        if (split.length == 2) {
            String localname = EscapeJCRUtil.escape(split[1]);
            String name = split[0] + ":" + localname;
            return name;
        }
        String localname = EscapeJCRUtil.escape(split[0]);
        return localname;
    }

    private static String escapeValues(String str) {
        char[] chars = str.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                buf.append(EscapeJCRUtil.escapeChar(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static boolean canMisinterpret(String str) {
        String sub16;
        boolean misinterprete = false;
        if (str.length() >= 7 && (sub16 = str.substring(0, 7)).matches(utf16esc)) {
            misinterprete = true;
        }
        return misinterprete;
    }

    private static String escapeChar(char c) {
        String unicodeRepr = Integer.toHexString(c);
        StringBuffer escaped = new StringBuffer();
        escaped.append("_x");
        escaped.append(Utf16Padding, 0, utf16length - unicodeRepr.length());
        escaped.append(unicodeRepr);
        escaped.append("_");
        return escaped.toString();
    }

    private static String escape(String str) {
        char[] chars = str.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            String substr;
            char c = chars[i];
            if (i == 0) {
                if (!XMLChar.isNameStart(c)) {
                    String escaped = EscapeJCRUtil.escapeChar(c);
                    buf.append(escaped);
                    continue;
                }
                substr = str.substring(i, str.length());
                if (EscapeJCRUtil.canMisinterpret(substr)) {
                    buf.append(EscapeJCRUtil.escapeChar(c));
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (!XMLChar.isName(c)) {
                buf.append(EscapeJCRUtil.escapeChar(c));
                continue;
            }
            substr = str.substring(i, str.length());
            if (EscapeJCRUtil.canMisinterpret(substr)) {
                buf.append(EscapeJCRUtil.escapeChar(c));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

