/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetPropertyValueTest
extends AbstractJCRTest {
    private Node testNode;
    private Value v1;
    private Value v2;
    private Value[] vArray1 = new Value[3];
    private Value[] vArray2 = new Value[3];
    private Value[] vArrayMixed = new Value[3];
    private Value[] vArrayNull = new Value[3];
    private Value[] vArrayWithNulls = new Value[5];

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.v1 = this.superuser.getValueFactory().createValue("abc");
        this.v2 = this.superuser.getValueFactory().createValue("xyz");
        this.vArray1[0] = this.superuser.getValueFactory().createValue("a");
        this.vArray1[1] = this.superuser.getValueFactory().createValue("b");
        this.vArray1[2] = this.superuser.getValueFactory().createValue("c");
        this.vArray2[0] = this.superuser.getValueFactory().createValue("x");
        this.vArray2[1] = this.superuser.getValueFactory().createValue("y");
        this.vArray2[2] = this.superuser.getValueFactory().createValue("z");
        this.vArrayMixed[0] = this.superuser.getValueFactory().createValue("abc");
        this.vArrayMixed[1] = this.superuser.getValueFactory().createValue(true);
        this.vArrayMixed[2] = this.superuser.getValueFactory().createValue(0x80000002L);
        this.vArrayWithNulls[1] = this.superuser.getValueFactory().createValue("a");
        this.vArrayWithNulls[3] = this.superuser.getValueFactory().createValue("z");
    }

    protected void tearDown() throws Exception {
        int i;
        this.testNode = null;
        this.v1 = null;
        this.v2 = null;
        for (i = 0; i < this.vArray1.length; ++i) {
            this.vArray1[i] = null;
        }
        for (i = 0; i < this.vArray2.length; ++i) {
            this.vArray2[i] = null;
        }
        for (i = 0; i < this.vArrayMixed.length; ++i) {
            this.vArrayMixed[i] = null;
        }
        for (i = 0; i < this.vArrayNull.length; ++i) {
            this.vArrayNull[i] = null;
        }
        for (i = 0; i < this.vArrayWithNulls.length; ++i) {
            this.vArrayWithNulls[i] = null;
        }
        super.tearDown();
    }

    public void testNewValuePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Setting property with Node.setProperty(String, Value) and Session.save() not working", (Object)this.v1, (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testModifyValuePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.v2);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Modifying property with Node.setProperty(String, Value) and Session.save() not working", (Object)this.v2, (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testNewValuePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1);
        this.testRootNode.save();
        SetPropertyValueTest.assertEquals((String)"Setting property with Node.setProperty(String, Value) and parentNode.save() not working", (Object)this.v1, (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testModifyValuePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, this.v2);
        this.testRootNode.save();
        SetPropertyValueTest.assertEquals((String)"Modifying property with Node.setProperty(String, Value) and parentNode.save() not working", (Object)this.v2, (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testRemoveValuePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.superuser.save();
        SetPropertyValueTest.assertFalse((String)"Removing property with Node.setProperty(String, (Value)null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveValuePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.testRootNode.save();
        SetPropertyValueTest.assertFalse((String)"Removing property with Node.setProperty(String, (Value)null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testNewValuePropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1, 1);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Setting property with Node.setProperty(String, Value, int) and Session.save() not working", (Object)this.v1, (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testModifyValuePropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1, 1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.v2, 1);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Modifying property with Node.setProperty(String, Value, int) and Session.save() not working", (Object)this.v2, (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testNewValuePropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1, 1);
        this.testRootNode.save();
        SetPropertyValueTest.assertEquals((String)"Setting property with Node.setProperty(String, Value, int) and parentNode.save() not working", (Object)this.v1, (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testModifyValuePropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1, 1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, this.v2, 1);
        this.testRootNode.save();
        SetPropertyValueTest.assertEquals((String)"Modifying property with Node.setProperty(String, Value, int) and parentNode.save() not working", (Object)this.v2, (Object)this.testNode.getProperty(this.propertyName1).getValue());
    }

    public void testRemoveValuePropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1, 1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (Value)null, 1);
        this.superuser.save();
        SetPropertyValueTest.assertFalse((String)"Removing property with Node.setProperty(String, (Value)null, int) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveValuePropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.v1, 1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName1, (Value)null, 1);
        this.testRootNode.save();
        SetPropertyValueTest.assertFalse((String)"Removing property with Node.setProperty(String, (Value)null, int) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testNewValueArrayPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Setting properties with Node.setProperty(String, Value[]) and Session.save() not working", Arrays.asList(this.vArray1), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testModifyValueArrayPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName2, this.vArray2);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Modifying properties with Node.setProperty(String, Value[]) and Session.save() not working", Arrays.asList(this.vArray2), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testNewValueArrayPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1);
        this.testRootNode.save();
        SetPropertyValueTest.assertEquals((String)"Setting properties with Node.setProperty(String, Value[]) and parentNode.save() not working", Arrays.asList(this.vArray1), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testModifyValueArrayPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName2, this.vArray2);
        this.testRootNode.save();
        SetPropertyValueTest.assertEquals((String)"Modifying properties with Node.setProperty(String, Value[]) and parentNode.save() not working", Arrays.asList(this.vArray2), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testSetMixedValueArrayValueFormatException() throws Exception {
        try {
            this.testNode.setProperty(this.propertyName2, this.vArrayMixed);
            SetPropertyValueTest.fail((String)"setProperty(String, mixedValueArray[]) not throwing a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testSetSingleValueArrayValueFormatException() throws Exception {
        if (!this.testNode.hasProperty(this.propertyName1)) {
            this.testNode.setProperty(this.propertyName1, this.v1);
            this.testNode.getParent().save();
        }
        try {
            this.testNode.setProperty(this.propertyName1, this.vArray1);
            SetPropertyValueTest.fail((String)"setProperty(singleValueProperty, Value[]) not throwing a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testRemoveValueArrayPropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName2, (Value[])null);
        this.superuser.save();
        SetPropertyValueTest.assertFalse((String)"Removing property with Node.setProperty(String, (Value[])null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName2));
    }

    public void testRemoveValueArrayPropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName2, (Value[])null);
        this.testRootNode.save();
        SetPropertyValueTest.assertFalse((String)"Removing property with Node.setProperty(String, (Value[])null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName2));
    }

    public void testSetNullValueArray() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArrayNull);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Node.setProperty(String, nullValueArray[]) did not set the property to an empty Value[]", Arrays.asList(new Value[0]), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testCompactValueArrayWithNulls() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArrayWithNulls);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Node.setProperty(String, valueArrayWithNulls[]) did not compact the value array by removing the null values", (int)2, (int)this.testNode.getProperty(this.propertyName2).getValues().length);
    }

    public void testNewValueArrayPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1, 1);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Setting properties with Node.setProperty(String, Value[], int) and Session.save() not working", Arrays.asList(this.vArray1), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testModifyValueArrayPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1, 1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName2, this.vArray2, 1);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Modifying properties with Node.setProperty(String, Value[], int) and Session.save() not working", Arrays.asList(this.vArray2), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testNewValueArrayPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1, 1);
        this.testRootNode.save();
        SetPropertyValueTest.assertEquals((String)"Setting properties with Node.setProperty(String, Value[], int) and parentNode.save() not working", Arrays.asList(this.vArray1), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testModifyValueArrayPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1, 1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName2, this.vArray2, 1);
        this.testRootNode.save();
        SetPropertyValueTest.assertEquals((String)"Modifying properties with Node.setProperty(String, Value[], int) and parentNode.save() not working", Arrays.asList(this.vArray2), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }

    public void testSetMixedValueArrayValueFormatExceptionWithPropertyType() throws Exception {
        try {
            this.testNode.setProperty(this.propertyName2, this.vArrayMixed, 1);
            SetPropertyValueTest.fail((String)"setProperty(String, mixedValueArray[], int) not throwing a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testSetSingleValueArrayValueFormatExceptionWithPropertyType() throws Exception {
        if (!this.testNode.hasProperty(this.propertyName1)) {
            this.testNode.setProperty(this.propertyName1, this.v1);
            this.testNode.getParent().save();
        }
        try {
            this.testNode.setProperty(this.propertyName1, this.vArray1, 1);
            SetPropertyValueTest.fail((String)"setProperty(singleValueProperty, Value[], int) not throwing a ValueFormatException");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testRemoveValueArrayPropertySessionWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1, 1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName2, (Value[])null, 1);
        this.superuser.save();
        SetPropertyValueTest.assertFalse((String)"Removing property with Node.setProperty(String, (Value[])null, int) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName2));
    }

    public void testRemoveValueArrayPropertyParentWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArray1, 1);
        this.testRootNode.save();
        this.testNode.setProperty(this.propertyName2, (Value[])null, 1);
        this.testRootNode.save();
        SetPropertyValueTest.assertFalse((String)"Removing property with Node.setProperty(String, (Value[])null, int) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName2));
    }

    public void testSetNullValueArrayWithPropertyType() throws Exception {
        this.testNode.setProperty(this.propertyName2, this.vArrayNull, 1);
        this.superuser.save();
        SetPropertyValueTest.assertEquals((String)"Node.setProperty(String, nullValueArray[], int) did not set the property to an empty Value[]", Arrays.asList(new Value[0]), Arrays.asList(this.testNode.getProperty(this.propertyName2).getValues()));
    }
}

