/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceCopyTest;

public class WorkspaceCopyTest
extends AbstractWorkspaceCopyTest {
    public void testCopyNodes() throws RepositoryException {
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        this.workspace.copy(this.node1.getPath(), dstAbsPath);
        WorkspaceCopyTest.assertFalse((boolean)this.superuser.hasPendingChanges());
    }

    public void testCopyNodesAbsolutePath() {
        try {
            String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName() + "[2]";
            this.workspace.copy(this.node1.getPath(), dstAbsPath);
            WorkspaceCopyTest.fail((String)"Copying a node to an absolute path containing index should not be possible.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testCopyNodesConstraintViolationException() throws RepositoryException {
        String nodetype = this.testNodeTypeNoChildren == null ? this.ntBase : this.testNodeTypeNoChildren;
        Node subNodesNotAllowedNode = this.testRootNode.addNode(this.nodeName3, nodetype);
        this.testRootNode.save();
        try {
            String dstAbsPath = subNodesNotAllowedNode.getPath() + "/" + this.node2.getName();
            this.workspace.copy(this.node2.getPath(), dstAbsPath);
            WorkspaceCopyTest.fail((String)"Copying a node below a node which can not have any sub nodes should throw a ConstraintViolationException.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyNodesAccessDenied() throws RepositoryException {
        Session readOnlySuperuser = this.getHelper().getReadOnlySession();
        try {
            String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
            try {
                readOnlySuperuser.getWorkspace().copy(this.node1.getPath(), dstAbsPath);
                WorkspaceCopyTest.fail((String)"Copy in a read-only session should throw an AccessDeniedException.");
            }
            catch (AccessDeniedException accessDeniedException) {
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            readOnlySuperuser.logout();
            throw throwable;
        }
        readOnlySuperuser.logout();
    }

    public void testCopyNodesPathNotExisting() throws RepositoryException {
        String srcAbsPath = this.node1.getPath();
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        String invalidSrcPath = srcAbsPath + "invalid";
        try {
            this.workspace.copy(invalidSrcPath, dstAbsPath);
            WorkspaceCopyTest.fail((String)("Not existing source path '" + invalidSrcPath + "' should throw PathNotFoundException."));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        String invalidDstParentPath = this.node2.getPath() + "invalid/" + this.node1.getName();
        try {
            this.workspace.copy(srcAbsPath, invalidDstParentPath);
            WorkspaceCopyTest.fail((String)("Not existing destination parent path '" + invalidDstParentPath + "' should throw PathNotFoundException."));
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyNodesLocked() throws RepositoryException, NotExecutableException {
        String dstAbsPath = this.node2.getPath() + "/" + this.node1.getName();
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            block6: {
                Node lockTarget = (Node)otherSession.getItem(this.node2.getPath());
                this.ensureMixinType(lockTarget, this.mixLockable);
                lockTarget.getParent().save();
                lockTarget.lock(true, true);
                try {
                    try {
                        this.workspace.copy(this.node1.getPath(), dstAbsPath);
                        WorkspaceCopyTest.fail((String)"LockException was expected.");
                    }
                    catch (LockException e) {
                        Object var6_5 = null;
                        lockTarget.unlock();
                        break block6;
                    }
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    lockTarget.unlock();
                    throw throwable;
                }
                lockTarget.unlock();
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            otherSession.logout();
            throw throwable;
        }
        otherSession.logout();
    }
}

