/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.lock;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLockTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger((Class)AbstractLockTest.class);
    protected LockManager lockMgr;
    protected Node lockedNode;
    protected Node childNode;
    protected Lock lock;

    protected void setUp() throws Exception {
        this.checkSupportedOption("option.locking.supported");
        super.setUp();
        this.lockedNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(this.lockedNode, this.mixLockable);
        this.childNode = this.lockedNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        this.lockMgr = AbstractLockTest.getLockManager(this.testRootNode.getSession());
        this.lock = this.lockMgr.lock(this.lockedNode.getPath(), this.isDeep(), this.isSessionScoped(), this.getTimeoutHint(), this.getLockOwner());
    }

    protected void tearDown() throws Exception {
        if (this.lockMgr != null && this.lockedNode != null && this.lockMgr.isLocked(this.lockedNode.getPath())) {
            try {
                this.lockMgr.unlock(this.lockedNode.getPath());
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        super.tearDown();
    }

    protected abstract boolean isSessionScoped();

    protected abstract boolean isDeep();

    protected void assertLockable(Node n) throws RepositoryException, NotExecutableException {
        this.ensureMixinType(n, this.mixLockable);
        n.getSession().save();
    }

    protected long getTimeoutHint() throws RepositoryException {
        String timoutStr = this.getProperty("lock.timeout");
        long hint = Long.MAX_VALUE;
        if (timoutStr != null) {
            try {
                hint = Long.parseLong(timoutStr);
            }
            catch (NumberFormatException e) {
                log.warn(e.getMessage());
            }
        }
        return hint;
    }

    protected String getLockOwner() throws RepositoryException {
        String ownerStr = this.getProperty("lock.owner");
        if (ownerStr == null) {
            ownerStr = this.superuser.getUserID();
        }
        return ownerStr;
    }

    protected static LockManager getLockManager(Session session) throws RepositoryException {
        return session.getWorkspace().getLockManager();
    }

    public void testIsDeep() {
        AbstractLockTest.assertEquals((String)"Lock.isDeep must be consistent with lock call.", (boolean)this.isDeep(), (boolean)this.lock.isDeep());
    }

    public void testIsLive() throws RepositoryException {
        AbstractLockTest.assertTrue((String)"Lock.isLive must be true.", (boolean)this.lock.isLive());
    }

    public void testRefresh() throws RepositoryException {
        this.lock.refresh();
    }

    public void testRefreshNotLive() throws Exception {
        this.lockMgr.unlock(this.lockedNode.getPath());
        try {
            this.lock.refresh();
            AbstractLockTest.fail((String)"Refresh on a lock that is not alive must fail");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testLockHoldingNode() throws RepositoryException {
        AbstractLockTest.assertTrue((String)"Lock.getNode() must be lockholding node.", (boolean)this.lock.getNode().isSame((Item)this.lockedNode));
    }

    public void testNodeIsLocked() throws RepositoryException {
        AbstractLockTest.assertTrue((String)"Node must be locked after lock creation.", (boolean)this.lockedNode.isLocked());
        AbstractLockTest.assertTrue((String)"Node must be locked after lock creation.", (boolean)this.lockMgr.isLocked(this.lockedNode.getPath()));
    }

    public void testNodeHoldsLocked() throws RepositoryException {
        AbstractLockTest.assertTrue((String)"Node must hold lock after lock creation.", (boolean)this.lockedNode.holdsLock());
        AbstractLockTest.assertTrue((String)"Node must hold lock after lock creation.", (boolean)this.lockMgr.holdsLock(this.lockedNode.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockVisibility() throws RepositoryException {
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            Node ln = (Node)otherSession.getItem(this.lockedNode.getPath());
            AbstractLockTest.assertTrue((String)"Locked node must also be locked for another session", (boolean)ln.isLocked());
            AbstractLockTest.assertTrue((String)"Locked node must also be locked for another session", (boolean)ln.holdsLock());
            AbstractLockTest.assertTrue((String)"Locked node must also be locked for another session", (boolean)AbstractLockTest.getLockManager(otherSession).holdsLock(ln.getPath()));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            otherSession.logout();
            throw throwable;
        }
        otherSession.logout();
    }

    public void testIsSessionScoped() {
        AbstractLockTest.assertEquals((String)"Lock.isSessionScoped must be consistent with lock call.", (boolean)this.isSessionScoped(), (boolean)this.lock.isSessionScoped());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLockOwningSession() throws RepositoryException {
        AbstractLockTest.assertTrue((String)"Session must be lock owner", (boolean)this.lock.isLockOwningSession());
        AbstractLockTest.assertTrue((String)"Session must be lock owner", (boolean)this.lockedNode.getLock().isLockOwningSession());
        AbstractLockTest.assertTrue((String)"Session must be lock owner", (boolean)this.lockMgr.getLock(this.lockedNode.getPath()).isLockOwningSession());
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Lock lck = otherSession.getNode(this.lockedNode.getPath()).getLock();
            AbstractLockTest.assertFalse((String)"Session must not be lock owner", (boolean)lck.isLockOwningSession());
            Lock lck2 = AbstractLockTest.getLockManager(otherSession).getLock(this.lockedNode.getPath());
            AbstractLockTest.assertFalse((String)"Session must not be lock owner", (boolean)lck2.isLockOwningSession());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            otherSession.logout();
            throw throwable;
        }
        otherSession.logout();
        Session otherAdmin = this.getHelper().getSuperuserSession();
        try {
            Lock lck = otherAdmin.getNode(this.lockedNode.getPath()).getLock();
            AbstractLockTest.assertFalse((String)"Other Session for the same userID must not be lock owner", (boolean)lck.isLockOwningSession());
            Lock lck2 = AbstractLockTest.getLockManager(otherAdmin).getLock(this.lockedNode.getPath());
            AbstractLockTest.assertFalse((String)"Other Session for the same userID must not be lock owner", (boolean)lck2.isLockOwningSession());
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            otherAdmin.logout();
            throw throwable;
        }
        otherAdmin.logout();
    }

    public void testGetSecondsRemaining() throws RepositoryException {
        if (this.lock.isLive()) {
            AbstractLockTest.assertTrue((String)"Seconds remaining must be a positive long.", (this.lock.getSecondsRemaining() > 0L ? 1 : 0) != 0);
        } else {
            AbstractLockTest.assertTrue((String)"Seconds remaining must be a negative long.", (this.lock.getSecondsRemaining() < 0L ? 1 : 0) != 0);
        }
    }

    public void testGetSecondsRemainingAfterUnlock() throws RepositoryException {
        this.lockMgr.unlock(this.lockedNode.getPath());
        AbstractLockTest.assertTrue((String)"Lock has been released: seconds remaining must be a negative long.", (this.lock.getSecondsRemaining() < 0L ? 1 : 0) != 0);
    }

    public synchronized void testLockExpiration() throws RepositoryException, NotExecutableException {
        this.lockedNode.unlock();
        long hint = 1L;
        this.lock = this.lockMgr.lock(this.lockedNode.getPath(), this.isDeep(), this.isSessionScoped(), hint, null);
        long remaining = this.lock.getSecondsRemaining();
        if (remaining <= hint) {
            try {
                ((Object)((Object)this)).wait(remaining * 2000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        } else {
            throw new NotExecutableException("timeout hint was ignored.");
        }
        long secs = this.lock.getSecondsRemaining();
        AbstractLockTest.assertTrue((String)("A released lock must return a negative number of seconds, was: " + secs), (secs < 0L ? 1 : 0) != 0);
        String message = "If the timeout hint is respected the lock must be automatically released.";
        AbstractLockTest.assertFalse((String)message, (boolean)this.lock.isLive());
        AbstractLockTest.assertFalse((String)message, (boolean)this.lockedNode.isLocked());
        AbstractLockTest.assertFalse((String)message, (boolean)this.lockMgr.isLocked(this.lockedNode.getPath()));
        AbstractLockTest.assertFalse((String)message, (boolean)this.lockedNode.hasProperty("{http://www.jcp.org/jcr/1.0}lockIsDeep"));
        AbstractLockTest.assertFalse((String)message, (boolean)this.lockedNode.hasProperty("{http://www.jcp.org/jcr/1.0}lockOwner"));
    }

    public void testUnlock() throws RepositoryException {
        this.lockMgr.unlock(this.lockedNode.getPath());
        AbstractLockTest.assertFalse((String)"lock must not be alive", (boolean)this.lock.isLive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testUnlockByOtherSession() throws RepositoryException, NotExecutableException {
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            try {
                AbstractLockTest.getLockManager(otherSession).unlock(this.lockedNode.getPath());
                AbstractLockTest.fail((String)"Another session must not be allowed to unlock.");
            }
            catch (LockException e) {
                AbstractLockTest.assertTrue((boolean)this.lockMgr.isLocked(this.lockedNode.getPath()));
                AbstractLockTest.assertTrue((boolean)this.lockedNode.hasProperty(this.jcrlockIsDeep));
                AbstractLockTest.assertTrue((boolean)this.lockedNode.hasProperty(this.jcrLockOwner));
                Object var4_3 = null;
                otherSession.logout();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            otherSession.logout();
            throw throwable;
        }
        otherSession.logout();
    }

    public void testIsLockedChild() throws RepositoryException {
        AbstractLockTest.assertEquals((String)"Child node must be locked according to isDeep flag.", (boolean)this.isDeep(), (boolean)this.childNode.isLocked());
        AbstractLockTest.assertEquals((String)"Child node must be locked according to isDeep flag.", (boolean)this.isDeep(), (boolean)this.lockMgr.isLocked(this.childNode.getPath()));
    }

    public void testIsLockedNewChild() throws RepositoryException {
        Node newChild = this.lockedNode.addNode(this.nodeName3, this.testNodeType);
        AbstractLockTest.assertEquals((String)"New child node must be locked according to isDeep flag.", (boolean)this.isDeep(), (boolean)newChild.isLocked());
        AbstractLockTest.assertEquals((String)"New child node must be locked according to isDeep flag.", (boolean)this.isDeep(), (boolean)this.lockMgr.isLocked(newChild.getPath()));
    }

    public void testHoldsLockChild() throws RepositoryException {
        AbstractLockTest.assertFalse((String)"Child node below a locked node must never be lock holder", (boolean)this.childNode.holdsLock());
        AbstractLockTest.assertFalse((String)"Child node below a locked node must never be lock holder", (boolean)this.lockMgr.holdsLock(this.childNode.getPath()));
    }

    public void testHoldsLockNewChild() throws RepositoryException {
        Node newChild = this.lockedNode.addNode(this.nodeName3, this.testNodeType);
        AbstractLockTest.assertFalse((String)"Child node below a locked node must never be lock holder", (boolean)newChild.holdsLock());
        AbstractLockTest.assertFalse((String)"Child node below a locked node must never be lock holder", (boolean)this.lockMgr.holdsLock(newChild.getPath()));
    }

    public void testGetLockOnChild() throws RepositoryException {
        if (this.isDeep()) {
            Lock lock = this.childNode.getLock();
            AbstractLockTest.assertNotNull((Object)lock);
            AbstractLockTest.assertTrue((String)"Lock.getNode() must return the lock holding node", (boolean)this.lockedNode.isSame((Item)lock.getNode()));
            Lock lock2 = this.lockMgr.getLock(this.childNode.getPath());
            AbstractLockTest.assertNotNull((Object)lock2);
            AbstractLockTest.assertTrue((String)"Lock.getNode() must return the lock holding node", (boolean)this.lockedNode.isSame((Item)lock2.getNode()));
        } else {
            try {
                this.childNode.getLock();
                AbstractLockTest.fail((String)"Node.getLock() must throw if node is not locked.");
            }
            catch (LockException e) {
                // empty catch block
            }
            try {
                this.lockMgr.getLock(this.childNode.getPath());
                AbstractLockTest.fail((String)"LockManager.getLock(String) must throw if node is not locked.");
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
    }

    public void testGetLockOnNewChild() throws RepositoryException {
        Node newChild = this.lockedNode.addNode(this.nodeName3, this.testNodeType);
        if (this.isDeep()) {
            Lock lock = newChild.getLock();
            AbstractLockTest.assertNotNull((Object)lock);
            AbstractLockTest.assertTrue((String)"Lock.getNode() must return the lock holding node", (boolean)this.lockedNode.isSame((Item)lock.getNode()));
            Lock lock2 = this.lockMgr.getLock(newChild.getPath());
            AbstractLockTest.assertNotNull((Object)lock2);
            AbstractLockTest.assertTrue((String)"Lock.getNode() must return the lock holding node", (boolean)this.lockedNode.isSame((Item)lock2.getNode()));
        } else {
            try {
                newChild.getLock();
                AbstractLockTest.fail((String)"Node.getLock() must throw if node is not locked.");
            }
            catch (LockException e) {
                // empty catch block
            }
            try {
                this.lockMgr.getLock(newChild.getPath());
                AbstractLockTest.fail((String)"LockManager.getLock(String) must throw if node is not locked.");
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveMixLockableFromLockedNode() throws RepositoryException, NotExecutableException {
        try {
            try {
                this.lockedNode.removeMixin(this.mixLockable);
                this.lockedNode.save();
                String msg = "Lock should have been released.";
                AbstractLockTest.assertFalse((String)msg, (boolean)this.lock.isLive());
                AbstractLockTest.assertFalse((String)msg, (boolean)this.lockedNode.isLocked());
                AbstractLockTest.assertFalse((String)msg, (boolean)this.lockMgr.isLocked(this.lockedNode.getPath()));
                AbstractLockTest.assertFalse((String)msg, (boolean)this.lockedNode.hasProperty(this.jcrLockOwner));
                AbstractLockTest.assertFalse((String)msg, (boolean)this.lockedNode.hasProperty(this.jcrlockIsDeep));
            }
            catch (ConstraintViolationException e) {
                String msg = "Lock must still be live.";
                AbstractLockTest.assertTrue((String)msg, (boolean)this.lock.isLive());
                AbstractLockTest.assertTrue((String)msg, (boolean)this.lockedNode.isLocked());
                AbstractLockTest.assertTrue((String)msg, (boolean)this.lockMgr.isLocked(this.lockedNode.getPath()));
                AbstractLockTest.assertTrue((String)msg, (boolean)this.lockedNode.hasProperty(this.jcrLockOwner));
                AbstractLockTest.assertTrue((String)msg, (boolean)this.lockedNode.hasProperty(this.jcrlockIsDeep));
                Object var4_4 = null;
                if (!this.lockedNode.isLocked()) return;
                this.ensureMixinType(this.lockedNode, this.mixLockable);
                this.lockedNode.save();
                return;
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!this.lockedNode.isLocked()) throw throwable;
            this.ensureMixinType(this.lockedNode, this.mixLockable);
            this.lockedNode.save();
            throw throwable;
        }
        if (!this.lockedNode.isLocked()) return;
        this.ensureMixinType(this.lockedNode, this.mixLockable);
        this.lockedNode.save();
    }
}

