/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.ISO8601;

public class NodeTypeUtil {
    public static final int ANY_PROPERTY_TYPE = -1;

    public static NodeDefinition locateChildNodeDef(Session session, boolean regardDefaultPrimaryType, boolean defaultPrimaryType, boolean residual) throws RepositoryException {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator types = manager.getAllNodeTypes();
        boolean overjump = false;
        block0: while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            NodeDefinition[] childDefs = type.getChildNodeDefinitions();
            int residuals = 0;
            for (int i = 0; i < childDefs.length; ++i) {
                if (!childDefs[i].getName().equals("*")) continue;
                ++residuals;
            }
            if (residuals > 1) continue;
            NodeDefinition[] nodeDefs = type.getDeclaredChildNodeDefinitions();
            for (int i = 0; i < nodeDefs.length; ++i) {
                NodeDefinition nodeDef = nodeDefs[i];
                if (nodeDef.isProtected() || nodeDef.getRequiredPrimaryTypes().length > 1 || regardDefaultPrimaryType && (defaultPrimaryType && nodeDef.getDefaultPrimaryType() == null || !defaultPrimaryType && nodeDef.getDefaultPrimaryType() != null) || residual && !nodeDef.getName().equals("*")) continue;
                if (!residual) {
                    NodeDefinition[] nodeDefsAll = type.getChildNodeDefinitions();
                    for (int j = 0; j < nodeDefsAll.length; ++j) {
                        if (!nodeDefsAll[j].getName().equals("*")) continue;
                        overjump = true;
                        break;
                    }
                    if (overjump) {
                        overjump = false;
                        continue block0;
                    }
                }
                return nodeDef;
            }
        }
        return null;
    }

    public static NodeDefinition locateChildNodeDef(Session session, boolean isProtected, boolean mandatory) throws RepositoryException {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator types = manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            NodeDefinition[] nodeDefs = type.getDeclaredChildNodeDefinitions();
            for (int i = 0; i < nodeDefs.length; ++i) {
                NodeDefinition nodeDef = nodeDefs[i];
                if (nodeDef.getName().equals("*") || isProtected && !nodeDef.isProtected() || !isProtected && nodeDef.isProtected() || mandatory && !nodeDef.isMandatory() || !mandatory && nodeDef.isMandatory()) continue;
                return nodeDef;
            }
        }
        return null;
    }

    public static PropertyDefinition locatePropertyDef(Session session, int propertyType, boolean multiple, boolean isProtected, boolean constraints, boolean residual) throws RepositoryException {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator types = manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            PropertyDefinition[] propDefs = type.getDeclaredPropertyDefinitions();
            for (int i = 0; i < propDefs.length; ++i) {
                PropertyDefinition propDef = propDefs[i];
                if (propertyType != -1 && propDef.getRequiredType() != propertyType || propertyType == -1 && propDef.getRequiredType() == 0 || multiple && !propDef.isMultiple() || !multiple && propDef.isMultiple() || isProtected && !propDef.isProtected() || !isProtected && propDef.isProtected()) continue;
                String[] vc = propDef.getValueConstraints();
                if (!constraints && vc != null && vc.length > 0 || constraints && (vc == null || vc.length == 0) || !residual && propDef.getName().equals("*") || residual && !propDef.getName().equals("*") || residual && NodeTypeUtil.getNumResidualPropDefs(type) > 1 || !residual && NodeTypeUtil.getNumResidualPropDefs(type) > 0) continue;
                return propDef;
            }
        }
        return null;
    }

    private static int getNumResidualPropDefs(NodeType type) {
        PropertyDefinition[] pDefs = type.getPropertyDefinitions();
        int residuals = 0;
        for (int j = 0; j < pDefs.length; ++j) {
            PropertyDefinition pDef = pDefs[j];
            if (!pDef.getName().equals("*")) continue;
            ++residuals;
        }
        return residuals;
    }

    public static PropertyDefinition locatePropertyDef(Session session, boolean isProtected, boolean mandatory) throws RepositoryException {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator types = manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            PropertyDefinition[] propDefs = type.getDeclaredPropertyDefinitions();
            for (int i = 0; i < propDefs.length; ++i) {
                PropertyDefinition propDef = propDefs[i];
                if (propDef.getName().equals("*") || isProtected && !propDef.isProtected() || !isProtected && propDef.isProtected() || mandatory && !propDef.isMandatory() || !mandatory && propDef.isMandatory()) continue;
                return propDef;
            }
        }
        return null;
    }

    public static String getUndefinedChildNodeName(NodeType nodeType) {
        NodeDefinition[] nodeDefs = nodeType.getChildNodeDefinitions();
        StringBuffer s = new StringBuffer("X");
        for (int i = 0; i < nodeDefs.length; ++i) {
            s.append(nodeDefs[i].getName());
        }
        String undefinedName = s.toString();
        undefinedName = undefinedName.replaceAll("\\*", "");
        undefinedName = undefinedName.replaceAll(":", "");
        return undefinedName;
    }

    public static String getIllegalChildNodeType(NodeTypeManager manager, String legalType) throws RepositoryException {
        NodeTypeIterator types = manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            if (type.getName().equals(legalType)) continue;
            NodeType[] superTypes = type.getSupertypes();
            boolean isSubType = false;
            for (int i = 0; i < superTypes.length; ++i) {
                String name = superTypes[i].getName();
                if (!name.equals(legalType)) continue;
                isSubType = true;
                break;
            }
            if (isSubType) continue;
            return type.getName();
        }
        return null;
    }

    public static Value getValueOfType(Session session, int type) throws ValueFormatException, UnsupportedOperationException, RepositoryException {
        switch (type) {
            case 2: {
                return session.getValueFactory().createValue("abc", 2);
            }
            case 6: {
                return session.getValueFactory().createValue(true);
            }
            case 5: {
                return session.getValueFactory().createValue(Calendar.getInstance());
            }
            case 4: {
                return session.getValueFactory().createValue(1.0);
            }
            case 3: {
                return session.getValueFactory().createValue(1L);
            }
            case 7: {
                return session.getValueFactory().createValue("abc", 7);
            }
            case 8: {
                return session.getValueFactory().createValue("/abc", 8);
            }
        }
        return session.getValueFactory().createValue("abc");
    }

    public static Value getValueAccordingToValueConstraints(Session session, PropertyDefinition propDef, boolean satisfied) throws ValueFormatException, RepositoryException {
        int i;
        int type = propDef.getRequiredType();
        String[] constraints = propDef.getValueConstraints();
        if (constraints == null || constraints.length == 0) {
            return null;
        }
        switch (type) {
            case 2: {
                long absMin = 0L;
                long absMax = 0L;
                boolean absMinSet = false;
                boolean absMaxSet = false;
                boolean maxBoundless = false;
                boolean minBoundless = false;
                for (int i2 = 0; i2 < constraints.length; ++i2) {
                    if (!minBoundless) {
                        String minStr = NodeTypeUtil.getConstraintMin(constraints[i2]);
                        if (minStr == null) {
                            minBoundless = true;
                        } else {
                            long min = Long.valueOf(minStr);
                            if (!absMinSet) {
                                absMin = min;
                                absMinSet = true;
                            } else if (min < absMin) {
                                absMin = min;
                            }
                        }
                    }
                    if (maxBoundless) continue;
                    String maxStr = NodeTypeUtil.getConstraintMax(constraints[i2]);
                    if (maxStr == null) {
                        maxBoundless = true;
                        continue;
                    }
                    long max = Long.valueOf(maxStr);
                    if (!absMaxSet) {
                        absMax = max;
                        absMaxSet = true;
                        continue;
                    }
                    if (max <= absMax) continue;
                    absMin = max;
                }
                if (satisfied) {
                    StringBuffer content = new StringBuffer();
                    int i3 = 0;
                    while ((long)i3 <= absMin + 1L) {
                        content.append("X");
                        ++i3;
                    }
                    if (!maxBoundless && (long)content.length() >= absMax) {
                        return null;
                    }
                    return session.getValueFactory().createValue(content.toString(), 2);
                }
                if (!minBoundless && absMin > 1L) {
                    return session.getValueFactory().createValue("0", 2);
                }
                if (!maxBoundless) {
                    StringBuffer content = new StringBuffer();
                    int i4 = 0;
                    while ((long)i4 <= absMax) {
                        content.append("0123456789");
                        i4 += 10;
                    }
                    return session.getValueFactory().createValue(content.toString(), 2);
                }
                return null;
            }
            case 6: {
                if (constraints.length > 1) {
                    return null;
                }
                boolean value = Boolean.valueOf(constraints[0]);
                if (satisfied) {
                    return session.getValueFactory().createValue(value);
                }
                return session.getValueFactory().createValue(!value);
            }
            case 5: {
                Calendar absMin = null;
                Calendar absMax = null;
                boolean maxBoundless = false;
                boolean minBoundless = false;
                for (int i5 = 0; i5 < constraints.length; ++i5) {
                    if (!minBoundless) {
                        String minStr = NodeTypeUtil.getConstraintMin(constraints[i5]);
                        if (minStr == null) {
                            minBoundless = true;
                        } else {
                            Calendar min = ISO8601.parse(minStr);
                            if (absMin == null || min.before(absMin)) {
                                absMin = min;
                            }
                        }
                    }
                    if (maxBoundless) continue;
                    String maxStr = NodeTypeUtil.getConstraintMax(constraints[i5]);
                    if (maxStr == null) {
                        maxBoundless = true;
                        continue;
                    }
                    Calendar max = ISO8601.parse(maxStr);
                    if (absMax != null && !max.after(absMax)) continue;
                    absMax = max;
                }
                if (satisfied) {
                    if (absMin != null) {
                        absMin.setTimeInMillis(absMin.getTimeInMillis() + 1L);
                        if (absMin.after(absMax)) {
                            return null;
                        }
                        return session.getValueFactory().createValue(absMin);
                    }
                    if (absMax != null) {
                        absMax.setTimeInMillis(absMax.getTimeInMillis() - 1L);
                        if (absMax.before(absMin)) {
                            return null;
                        }
                        return session.getValueFactory().createValue(absMax);
                    }
                    return session.getValueFactory().createValue(Calendar.getInstance());
                }
                if (!minBoundless) {
                    absMin.setTimeInMillis(absMin.getTimeInMillis() - 1L);
                    return session.getValueFactory().createValue(absMin);
                }
                if (!maxBoundless) {
                    absMax.setTimeInMillis(absMax.getTimeInMillis() + 1L);
                    return session.getValueFactory().createValue(absMax);
                }
                return null;
            }
            case 4: {
                double absMin = 0.0;
                double absMax = 0.0;
                boolean absMinSet = false;
                boolean absMaxSet = false;
                boolean maxBoundless = false;
                boolean minBoundless = false;
                for (int i6 = 0; i6 < constraints.length; ++i6) {
                    if (!minBoundless) {
                        String minStr = NodeTypeUtil.getConstraintMin(constraints[i6]);
                        if (minStr == null) {
                            minBoundless = true;
                        } else {
                            double min = Double.valueOf(minStr);
                            if (!absMinSet) {
                                absMin = min;
                                absMinSet = true;
                            } else if (min < absMin) {
                                absMin = min;
                            }
                        }
                    }
                    if (maxBoundless) continue;
                    String maxStr = NodeTypeUtil.getConstraintMax(constraints[i6]);
                    if (maxStr == null) {
                        maxBoundless = true;
                        continue;
                    }
                    double max = Double.valueOf(maxStr);
                    if (!absMaxSet) {
                        absMax = max;
                        absMaxSet = true;
                        continue;
                    }
                    if (!(max > absMax)) continue;
                    absMax = max;
                }
                if (satisfied) {
                    if (minBoundless) {
                        return session.getValueFactory().createValue(absMax - 1.0);
                    }
                    if (maxBoundless) {
                        return session.getValueFactory().createValue(absMin + 1.0);
                    }
                    if (absMin < absMax) {
                        double d = (absMin + absMax) / 2.0;
                        return session.getValueFactory().createValue(d);
                    }
                    return null;
                }
                if (!minBoundless) {
                    return session.getValueFactory().createValue(absMin - 1.0);
                }
                if (!maxBoundless) {
                    return session.getValueFactory().createValue(absMax + 1.0);
                }
                return null;
            }
            case 3: {
                long absMin = 0L;
                long absMax = 0L;
                boolean absMinSet = false;
                boolean absMaxSet = false;
                boolean maxBoundless = false;
                boolean minBoundless = false;
                for (int i7 = 0; i7 < constraints.length; ++i7) {
                    if (!minBoundless) {
                        String minStr = NodeTypeUtil.getConstraintMin(constraints[i7]);
                        if (minStr == null) {
                            minBoundless = true;
                        } else {
                            long min = Long.valueOf(minStr);
                            if (!absMinSet) {
                                absMin = min;
                                absMinSet = true;
                            } else if (min < absMin) {
                                absMin = min;
                            }
                        }
                    }
                    if (maxBoundless) continue;
                    String maxStr = NodeTypeUtil.getConstraintMax(constraints[i7]);
                    if (maxStr == null) {
                        maxBoundless = true;
                        continue;
                    }
                    long max = Long.valueOf(maxStr);
                    if (!absMaxSet) {
                        absMax = max;
                        absMaxSet = true;
                        continue;
                    }
                    if (max <= absMax) continue;
                    absMax = max;
                }
                if (satisfied) {
                    if (minBoundless) {
                        return session.getValueFactory().createValue(absMax - 1L);
                    }
                    if (maxBoundless) {
                        return session.getValueFactory().createValue(absMin + 1L);
                    }
                    if (absMin < absMax - 1L) {
                        long x = (absMin + absMax) / 2L;
                        return session.getValueFactory().createValue(x);
                    }
                    return null;
                }
                if (!minBoundless) {
                    return session.getValueFactory().createValue(absMin - 1L);
                }
                if (!maxBoundless) {
                    return session.getValueFactory().createValue(absMax + 1L);
                }
                return null;
            }
            case 7: {
                if (satisfied) {
                    return null;
                }
                StringBuffer name = new StringBuffer("X");
                for (int i8 = 0; i8 < constraints.length; ++i8) {
                    name.append(constraints[i8].replaceAll(":", ""));
                }
                return session.getValueFactory().createValue(name.toString(), 7);
            }
            case 8: {
                if (satisfied) {
                    return null;
                }
                StringBuffer path = new StringBuffer("X");
                for (int i9 = 0; i9 < constraints.length; ++i9) {
                    path.append(constraints[i9]);
                }
                String pathStr = path.toString();
                pathStr = pathStr.replaceAll(":", "");
                pathStr = pathStr.replaceAll("\\*", "");
                pathStr = pathStr.replaceAll("//", "/");
                return session.getValueFactory().createValue(pathStr, 8);
            }
            case 0: {
                return null;
            }
        }
        if (satisfied) {
            return null;
        }
        StringBuffer value = new StringBuffer("X");
        for (i = 0; i < constraints.length; ++i) {
            value.append(constraints[i]);
        }
        for (i = 0; i < constraints.length; ++i) {
            Pattern pattern = Pattern.compile(constraints[i]);
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) continue;
            return null;
        }
        return session.getValueFactory().createValue(value.toString());
    }

    private static String getConstraintMin(String constraint) {
        String min = constraint.substring(0, constraint.indexOf(","));
        min = min.replaceAll("\\(", "");
        min = min.replaceAll("\\[", "");
        if ((min = min.replaceAll(" ", "")).equals("")) {
            min = null;
        }
        return min;
    }

    private static String getConstraintMax(String constraint) {
        String max = constraint.substring(constraint.indexOf(",") + 1);
        max = max.replaceAll("\\)", "");
        max = max.replaceAll("\\]", "");
        if ((max = max.replaceAll(" ", "")).equals("")) {
            max = null;
        }
        return max;
    }
}

