/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class NodeRemovedTest
extends AbstractObservationTest {
    public void testSingleNodeRemoved() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 2);
        Node foo = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        foo.remove();
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkNodeRemoved(events, new String[]{this.nodeName1}, null);
    }

    public void testMultiNodesRemoved() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 2);
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n1.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        n1.remove();
        this.testRootNode.save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkNodeRemoved(events, new String[]{this.nodeName1, this.nodeName1 + "/" + this.nodeName2}, null);
    }
}

