/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class ElementTest
extends AbstractQueryTest {
    private String simpleNodeType;

    protected void setUp() throws Exception {
        super.setUp();
        this.simpleNodeType = this.testNodeTypeNoChildren == null ? this.ntBase : this.testNodeTypeNoChildren;
    }

    public void testElementTest() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.simpleNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        String query = "/" + this.jcrRoot + this.testRoot + "/element()";
        this.executeXPathQuery(this.superuser, query, new Node[]{n1, n2, n3});
    }

    public void testElementTestAnyNode() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.simpleNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        String query = "/" + this.jcrRoot + this.testRoot + "/element(*)";
        this.executeXPathQuery(this.superuser, query, new Node[]{n1, n2, n3});
    }

    public void testElementTestAnyNodeNtBase() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.simpleNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        String query = "/" + this.jcrRoot + this.testRoot + "/element(*, " + this.ntBase + ")";
        this.executeXPathQuery(this.superuser, query, new Node[]{n1, n2, n3});
    }

    public void testElementTestAnyNodeSomeNT() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.simpleNodeType);
        Node n3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        String query = "/" + this.jcrRoot + this.testRoot + "/element(*, " + this.testNodeType + ")";
        this.executeXPathQuery(this.superuser, query, new Node[]{n1, n3});
    }

    public void testElementTestNameTest() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.simpleNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        String query = "/" + this.jcrRoot + this.testRoot + "/element(" + this.nodeName1 + ")";
        this.executeXPathQuery(this.superuser, query, new Node[]{n1});
    }

    public void testElementTestNameTestNtBase() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.simpleNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        String query = "/" + this.jcrRoot + this.testRoot + "/element(" + this.nodeName1 + ", " + this.ntBase + ")";
        this.executeXPathQuery(this.superuser, query, new Node[]{n1});
    }

    public void testElementTestNameTestSomeNT() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.simpleNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        String query = "/" + this.jcrRoot + this.testRoot + "/element(" + this.nodeName1 + ", " + this.testNodeType + ")";
        this.executeXPathQuery(this.superuser, query, new Node[]{n1});
    }

    public void testElementTestNameTestSomeNTWithSNS() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!n1.getDefinition().allowsSameNameSiblings()) {
            throw new NotExecutableException("Node at " + this.testRoot + " does not allow same name siblings with name " + this.nodeName1);
        }
        this.testRootNode.addNode(this.nodeName1, this.simpleNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.addNode(this.nodeName2, this.simpleNodeType);
        this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        String query = "/" + this.jcrRoot + this.testRoot + "/element(" + this.nodeName1 + ", " + this.testNodeType + ")";
        this.executeXPathQuery(this.superuser, query, new Node[]{n1, n2});
    }
}

