/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import junit.framework.Assert;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class FullTextSearchScoreTest
extends AbstractQOMTest {
    private static final String TEXT = "the quick brown fox jumps over the lazy dog.";

    protected void setUp() throws Exception {
        super.setUp();
        Node n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n1.setProperty(this.propertyName1, TEXT);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        n2.setProperty(this.propertyName1, TEXT);
        n2.setProperty(this.propertyName2, TEXT);
        this.superuser.save();
    }

    public void testOrdering() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.and((Constraint)this.qf.fullTextSearch("s", null, (StaticOperand)this.qf.literal(this.vf.createValue("fox"))), (Constraint)this.qf.descendantNode("s", this.testRootNode.getPath())), new Ordering[]{this.qf.ascending((DynamicOperand)this.qf.fullTextSearchScore("s"))}, null);
        this.forQOMandSQL2(qom, new AbstractQOMTest.Callable(){

            public Object call(Query query) throws RepositoryException {
                RowIterator rows = query.execute().getRows();
                double previousScore = Double.NaN;
                while (rows.hasNext()) {
                    double score = rows.nextRow().getScore("s");
                    if (!Double.isNaN(previousScore)) {
                        Assert.assertTrue((String)"wrong order", (previousScore <= score ? 1 : 0) != 0);
                    }
                    previousScore = score;
                }
                return null;
            }
        });
    }

    public void testConstraint() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.and((Constraint)this.qf.and((Constraint)this.qf.fullTextSearch("s", null, (StaticOperand)this.qf.literal(this.vf.createValue("fox"))), (Constraint)this.qf.comparison((DynamicOperand)this.qf.fullTextSearchScore("s"), "jcr.operator.greater.than", (StaticOperand)this.qf.literal(this.vf.createValue(Double.MIN_VALUE)))), (Constraint)this.qf.descendantNode("s", this.testRootNode.getPath())), new Ordering[]{this.qf.descending((DynamicOperand)this.qf.fullTextSearchScore("s"))}, null);
        this.forQOMandSQL2(qom, new AbstractQOMTest.Callable(){

            public Object call(Query query) throws RepositoryException {
                RowIterator rows = query.execute().getRows();
                while (rows.hasNext()) {
                    double score = rows.nextRow().getScore("s");
                    if (Double.isNaN(score)) continue;
                    Assert.assertTrue((String)"wrong full text search score", (Double.MIN_VALUE < score ? 1 : 0) != 0);
                }
                return null;
            }
        });
    }
}

