/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class GetQueryTest
extends AbstractQOMTest {
    public void testGetQuery() throws RepositoryException, NotExecutableException {
        this.checkNtQuery();
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        ArrayList<Object> queries = new ArrayList<Object>();
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.childNode("s", this.testRoot), null, null);
        queries.add(qom);
        queries.add(this.qm.createQuery(qom.getStatement(), "JCR-SQL2"));
        if (this.isSupportedLanguage("xpath")) {
            String xpath = this.testPath + "/element(*, " + this.testNodeType + ")";
            queries.add(this.qm.createQuery(xpath, "xpath"));
        }
        if (this.isSupportedLanguage("sql")) {
            String sql = "select * from " + this.testNodeType + " where jcr:path like '" + this.testRoot + "/%'";
            queries.add(this.qm.createQuery(sql, "sql"));
        }
        Iterator it = queries.iterator();
        while (it.hasNext()) {
            Query q = (Query)it.next();
            String lang = q.getLanguage();
            this.checkResult(q.execute(), new Node[]{n});
            Node stored = q.storeAsNode(this.testRoot + "/" + this.nodeName1);
            q = this.qm.getQuery(stored);
            GetQueryTest.assertEquals((String)"language of stored query does not match", (String)lang, (String)q.getLanguage());
            this.checkResult(q.execute(), new Node[]{n});
            stored.remove();
        }
    }

    public void testInvalidQueryException() throws RepositoryException {
        try {
            this.qm.getQuery(this.testRootNode);
            GetQueryTest.fail((String)"getQuery() must throw InvalidQueryException when node is not of type nt:query");
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
    }

    private void checkNtQuery() throws RepositoryException, NotExecutableException {
        try {
            this.superuser.getWorkspace().getNodeTypeManager().getNodeType(this.ntQuery);
        }
        catch (NoSuchNodeTypeException e) {
            throw new NotExecutableException("repository does not support nt:query");
        }
    }
}

