/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlListTest
extends AbstractAccessControlTest {
    private static Logger log = LoggerFactory.getLogger((Class)AccessControlListTest.class);
    private String path;
    private Privilege[] privs;
    private Principal testPrincipal;
    private List privilegesToRestore = new ArrayList();

    protected void setUp() throws Exception {
        this.checkSupportedOption("option.access.control.supported");
        super.setUp();
        try {
            Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.superuser.save();
            this.path = n.getPath();
            this.privs = this.acMgr.getSupportedPrivileges(this.path);
            if (this.privs.length == 0) {
                throw new NotExecutableException("No supported privileges at absPath " + this.path);
            }
            this.testPrincipal = this.getHelper().getKnownPrincipal(this.superuser);
            this.privilegesToRestore = AccessControlListTest.currentPrivileges(AccessControlListTest.getList(this.acMgr, this.path), this.testPrincipal);
        }
        catch (Exception e) {
            this.superuser.logout();
            throw e;
        }
    }

    protected void tearDown() throws Exception {
        try {
            AccessControlList list = AccessControlListTest.getList(this.acMgr, this.path);
            AccessControlEntry[] entries = list.getAccessControlEntries();
            for (int i = 0; i < entries.length; ++i) {
                AccessControlEntry ace = entries[i];
                if (!((Object)this.testPrincipal).equals(ace.getPrincipal())) continue;
                list.removeAccessControlEntry(ace);
            }
            if (!this.privilegesToRestore.isEmpty()) {
                list.addAccessControlEntry(this.testPrincipal, this.privilegesToRestore.toArray(new Privilege[this.privilegesToRestore.size()]));
            }
            if (list.getAccessControlEntries().length > 0 && this.acMgr.getPolicies(this.path).length > 0) {
                this.acMgr.setPolicy(this.path, (AccessControlPolicy)list);
                this.superuser.save();
            }
        }
        catch (Exception e) {
            log.warn("Unexpected error while removing test entries.", (Throwable)e);
        }
        super.tearDown();
    }

    private static AccessControlList getList(AccessControlManager acMgr, String path) throws NotExecutableException, AccessDeniedException, RepositoryException {
        AccessControlPolicyIterator it = acMgr.getApplicablePolicies(path);
        while (it.hasNext()) {
            AccessControlPolicy acp = it.nextAccessControlPolicy();
            if (!(acp instanceof AccessControlList)) continue;
            return (AccessControlList)acp;
        }
        AccessControlPolicy[] acps = acMgr.getPolicies(path);
        for (int i = 0; i < acps.length; ++i) {
            if (!(acps[i] instanceof AccessControlList)) continue;
            return (AccessControlList)acps[i];
        }
        throw new NotExecutableException("No AccessControlList at " + path);
    }

    private static List currentPrivileges(AccessControlList acl, Principal principal) throws RepositoryException {
        ArrayList<Privilege> privileges = new ArrayList<Privilege>();
        AccessControlEntry[] entries = acl.getAccessControlEntries();
        for (int i = 0; i < entries.length; ++i) {
            AccessControlEntry ace = entries[i];
            if (!((Object)principal).equals(ace.getPrincipal())) continue;
            privileges.addAll(Arrays.asList(ace.getPrivileges()));
        }
        return privileges;
    }

    public void testGetAccessControlEntries() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        AccessControlEntry[] entries = acl.getAccessControlEntries();
        AccessControlListTest.assertNotNull((String)"AccessControlList#getAccessControlEntries must not return null.", (Object)entries);
        for (int i = 0; i < entries.length; ++i) {
            AccessControlListTest.assertNotNull((String)"An ACE must contain a principal", (Object)entries[i].getPrincipal());
            Privilege[] privs = entries[i].getPrivileges();
            AccessControlListTest.assertTrue((String)"An ACE must contain at least a single privilege", (privs != null && privs.length > 0 ? 1 : 0) != 0);
        }
    }

    public void testAddAccessControlEntry() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        Privilege[] privileges = new Privilege[]{this.privs[0]};
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        AccessControlEntry entry = null;
        if (acl.addAccessControlEntry(this.testPrincipal, privileges)) {
            AccessControlEntry[] aces = acl.getAccessControlEntries();
            for (int i = 0; i < aces.length; ++i) {
                if (!((Object)aces[i].getPrincipal()).equals(this.testPrincipal) || !((Object)Arrays.asList(privileges)).equals(Arrays.asList(aces[i].getPrivileges()))) continue;
                entry = aces[i];
            }
            if (entry == null) {
                throw new NotExecutableException();
            }
        } else {
            throw new NotExecutableException();
        }
        AccessControlListTest.assertEquals((String)"Principal name of the ACE must be equal to the name of the passed Principal", (String)this.testPrincipal.getName(), (String)entry.getPrincipal().getName());
        AccessControlListTest.assertEquals((String)"Privileges of the ACE must be equal to the passed ones", Arrays.asList(privileges), Arrays.asList(entry.getPrivileges()));
    }

    public void testAddAggregatePrivilege() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        Privilege aggregate = null;
        for (int i = 0; i < this.privs.length; ++i) {
            if (!this.privs[i].isAggregate()) continue;
            aggregate = this.privs[i];
            break;
        }
        if (aggregate == null) {
            throw new NotExecutableException("No aggregate privilege supported at " + this.path);
        }
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        acl.addAccessControlEntry(this.testPrincipal, new Privilege[]{aggregate});
        List privs = AccessControlListTest.currentPrivileges(acl, this.testPrincipal);
        AccessControlListTest.assertTrue((String)"Privileges added through 'addAccessControlEntry' must be reflected upon getAccessControlEntries", (privs.contains(aggregate) || privs.containsAll(Arrays.asList(aggregate.getAggregatePrivileges())) ? 1 : 0) != 0);
    }

    public void testAddAggregatedPrivilegesSeparately() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        Privilege aggregate = null;
        for (int i = 0; i < this.privs.length; ++i) {
            if (!this.privs[i].isAggregate()) continue;
            aggregate = this.privs[i];
            break;
        }
        if (aggregate == null) {
            throw new NotExecutableException("No aggregate privilege supported at " + this.path);
        }
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        acl.addAccessControlEntry(this.testPrincipal, new Privilege[]{aggregate});
        Privilege[] privs = aggregate.getAggregatePrivileges();
        for (int i = 0; i < privs.length; ++i) {
            boolean modified = acl.addAccessControlEntry(this.testPrincipal, new Privilege[]{privs[i]});
            AccessControlListTest.assertFalse((String)"Adding the aggregated privs individually later on must not modify the policy", (boolean)modified);
        }
    }

    public void testAddAbstractPrivilege() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        Privilege abstractPriv = null;
        Privilege[] allPrivs = this.acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all").getAggregatePrivileges();
        for (int i = 0; i < allPrivs.length; ++i) {
            if (!allPrivs[i].isAbstract()) continue;
            abstractPriv = allPrivs[i];
            break;
        }
        if (abstractPriv == null) {
            throw new NotExecutableException("No abstract privilege found.");
        }
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        try {
            acl.addAccessControlEntry(this.testPrincipal, new Privilege[]{abstractPriv});
            AccessControlListTest.fail((String)"Adding an ACE with an abstract privilege must fail.");
        }
        catch (AccessControlException e) {
            // empty catch block
        }
    }

    public void testAddPrivilegesPresentInEntries() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        acl.addAccessControlEntry(this.testPrincipal, this.privs);
        HashSet<Privilege> assignedPrivs = new HashSet<Privilege>();
        AccessControlEntry[] entries = acl.getAccessControlEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (!((Object)entries[i].getPrincipal()).equals(this.testPrincipal)) continue;
            Privilege[] prvs = entries[i].getPrivileges();
            for (int j = 0; j < prvs.length; ++j) {
                if (prvs[j].isAggregate()) {
                    assignedPrivs.addAll(Arrays.asList(prvs[j].getAggregatePrivileges()));
                    continue;
                }
                assignedPrivs.add(prvs[j]);
            }
        }
        HashSet<Privilege> expected = new HashSet<Privilege>();
        for (int i = 0; i < this.privs.length; ++i) {
            if (this.privs[i].isAggregate()) {
                expected.addAll(Arrays.asList(this.privs[i].getAggregatePrivileges()));
                continue;
            }
            expected.add(this.privs[i]);
        }
        AccessControlListTest.assertTrue((String)"getAccessControlEntries must contain an entry or entries that grant at least the added privileges.", (boolean)assignedPrivs.containsAll(expected));
    }

    public void testAddAccessControlEntryAndSetPolicy() throws RepositoryException, NotExecutableException {
        this.checkCanModifyAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        List<AccessControlEntry> originalAces = Arrays.asList(acl.getAccessControlEntries());
        if (!acl.addAccessControlEntry(this.testPrincipal, this.privs)) {
            throw new NotExecutableException();
        }
        AccessControlListTest.assertEquals((String)"Before calling setPolicy any modifications to an ACL must not be reflected in the policies", originalAces, Arrays.asList(AccessControlListTest.getList(this.acMgr, this.path).getAccessControlEntries()));
        this.acMgr.setPolicy(this.path, (AccessControlPolicy)acl);
        AccessControlListTest.assertEquals((String)"Before calling setPolicy any modifications to an ACL must not be reflected in the policies", Arrays.asList(acl.getAccessControlEntries()), Arrays.asList(AccessControlListTest.getList(this.acMgr, this.path).getAccessControlEntries()));
    }

    public void testAddAccessControlEntryIsTransient() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        List<AccessControlEntry> originalAces = Arrays.asList(acl.getAccessControlEntries());
        if (!acl.addAccessControlEntry(this.testPrincipal, this.privs)) {
            throw new NotExecutableException();
        }
        this.acMgr.setPolicy(this.path, (AccessControlPolicy)acl);
        this.superuser.refresh(false);
        AccessControlListTest.assertEquals((String)"After calling Session.refresh() any changes to a nodes policies must be reverted.", originalAces, Arrays.asList(AccessControlListTest.getList(this.acMgr, this.path).getAccessControlEntries()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddAccessControlEntryInvalidPrincipal() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        try {
            try {
                Principal invalidPrincipal = this.getHelper().getUnknownPrincipal(this.superuser);
                AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
                acl.addAccessControlEntry(invalidPrincipal, this.privs);
                AccessControlListTest.fail((String)"Adding an entry with an unknown principal must throw AccessControlException.");
            }
            catch (AccessControlException accessControlException) {
                Object var4_5 = null;
                this.superuser.refresh(false);
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.superuser.refresh(false);
            throw throwable;
        }
        this.superuser.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddAccessControlEntryEmptyPrivilegeArray() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        try {
            try {
                Privilege[] invalidPrivs = new Privilege[]{};
                AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
                acl.addAccessControlEntry(this.testPrincipal, invalidPrivs);
                AccessControlListTest.fail((String)"Adding an entry with an invalid privilege array must throw AccessControlException.");
            }
            catch (AccessControlException accessControlException) {
                Object var4_5 = null;
                this.superuser.refresh(false);
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.superuser.refresh(false);
            throw throwable;
        }
        this.superuser.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddAccessControlEntryInvalidPrivilege() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        try {
            try {
                Privilege[] invalidPrivs = new Privilege[]{new Privilege(){

                    public String getName() {
                        return null;
                    }

                    public boolean isAbstract() {
                        return false;
                    }

                    public boolean isAggregate() {
                        return false;
                    }

                    public Privilege[] getDeclaredAggregatePrivileges() {
                        return new Privilege[0];
                    }

                    public Privilege[] getAggregatePrivileges() {
                        return new Privilege[0];
                    }
                }};
                AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
                acl.addAccessControlEntry(this.testPrincipal, invalidPrivs);
                AccessControlListTest.fail((String)"Adding an entry with an invalid privilege must throw AccessControlException.");
            }
            catch (AccessControlException accessControlException) {
                Object var4_5 = null;
                this.superuser.refresh(false);
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.superuser.refresh(false);
            throw throwable;
        }
        this.superuser.refresh(false);
    }

    public void testRemoveAccessControlEntry() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        AccessControlEntry[] entries = acl.getAccessControlEntries();
        if (entries.length > 0) {
            AccessControlEntry ace = entries[0];
            acl.removeAccessControlEntry(ace);
            List<AccessControlEntry> remainingEntries = Arrays.asList(acl.getAccessControlEntries());
            AccessControlListTest.assertFalse((String)"AccessControlList.getAccessControlEntries still returns a removed ACE.", (boolean)remainingEntries.contains(ace));
        }
    }

    public void testRemoveAddedAccessControlEntry() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        acl.addAccessControlEntry(this.testPrincipal, this.privs);
        AccessControlEntry[] aces = acl.getAccessControlEntries();
        for (int i = 0; i < aces.length; ++i) {
            acl.removeAccessControlEntry(aces[i]);
        }
        AccessControlListTest.assertEquals((String)"After removing all ACEs the ACL must be empty", (int)0, (int)acl.getAccessControlEntries().length);
    }

    public void testRemoveAccessControlEntryAndSetPolicy() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        if (!acl.addAccessControlEntry(this.testPrincipal, this.privs)) {
            throw new NotExecutableException();
        }
        this.acMgr.setPolicy(this.path, (AccessControlPolicy)acl);
        acl = AccessControlListTest.getList(this.acMgr, this.path);
        AccessControlEntry ace = null;
        AccessControlEntry[] aces = acl.getAccessControlEntries();
        if (aces.length == 0) {
            throw new NotExecutableException();
        }
        ace = aces[0];
        acl.removeAccessControlEntry(ace);
        AccessControlListTest.assertEquals((String)"Removal of an ACE must only be visible upon 'setPolicy'", Arrays.asList(aces), Arrays.asList(AccessControlListTest.getList(this.acMgr, this.path).getAccessControlEntries()));
        this.acMgr.setPolicy(this.path, (AccessControlPolicy)acl);
        AccessControlListTest.assertEquals((String)"After 'setPolicy' the ACE-removal must be visible to the editing session.", Arrays.asList(acl.getAccessControlEntries()), Arrays.asList(AccessControlListTest.getList(this.acMgr, this.path).getAccessControlEntries()));
    }

    public void testRemoveAccessControlEntryIsTransient() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        if (!acl.addAccessControlEntry(this.testPrincipal, this.privs)) {
            throw new NotExecutableException();
        }
        this.acMgr.setPolicy(this.path, (AccessControlPolicy)acl);
        this.superuser.save();
        acl = AccessControlListTest.getList(this.acMgr, this.path);
        AccessControlEntry ace = acl.getAccessControlEntries()[0];
        acl.removeAccessControlEntry(ace);
        this.acMgr.setPolicy(this.path, (AccessControlPolicy)acl);
        this.superuser.refresh(false);
        List<AccessControlEntry> entries = Arrays.asList(AccessControlListTest.getList(this.acMgr, this.path).getAccessControlEntries());
        AccessControlListTest.assertTrue((String)"After reverting any changes the removed ACE should be present again.", (boolean)entries.contains(ace));
    }

    public void testRemoveIllegalAccessControlEntry() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        try {
            AccessControlEntry entry = new AccessControlEntry(){

                public Principal getPrincipal() {
                    return AccessControlListTest.this.testPrincipal;
                }

                public Privilege[] getPrivileges() {
                    return AccessControlListTest.this.privs;
                }
            };
            AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
            acl.removeAccessControlEntry(entry);
            AccessControlListTest.fail((String)"AccessControlManager.removeAccessControlEntry with an unknown entry must throw AccessControlException.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testAddAccessControlEntryTwice() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        if (acl.addAccessControlEntry(this.testPrincipal, this.privs)) {
            AccessControlListTest.assertFalse((String)"Adding the same ACE twice should not modify the AC-List.", (boolean)acl.addAccessControlEntry(this.testPrincipal, this.privs));
        }
    }

    public void testAddAccessControlEntryAgain() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        AccessControlList list = AccessControlListTest.getList(this.acMgr, this.path);
        AccessControlEntry[] entries = list.getAccessControlEntries();
        if (entries.length <= 0) {
            throw new NotExecutableException();
        }
        AccessControlListTest.assertFalse((String)"Adding an existing entry again must not modify the AC-List", (boolean)list.addAccessControlEntry(entries[0].getPrincipal(), entries[0].getPrivileges()));
    }

    public void testExtendPrivileges() throws NotExecutableException, RepositoryException {
        this.checkCanModifyAc(this.path);
        ArrayList<Privilege> twoPrivs = new ArrayList<Privilege>(2);
        for (int i = 0; i < this.privs.length && twoPrivs.size() < 2; ++i) {
            if (this.privs[i].isAggregate()) continue;
            twoPrivs.add(this.privs[i]);
        }
        if (twoPrivs.size() < 2) {
            throw new NotExecutableException("At least 2 supported, non-aggregate privileges required at " + this.path);
        }
        AccessControlList acl = AccessControlListTest.getList(this.acMgr, this.path);
        Privilege privilege = (Privilege)twoPrivs.get(0);
        acl.addAccessControlEntry(this.testPrincipal, new Privilege[]{privilege});
        Privilege privilege2 = (Privilege)twoPrivs.get(1);
        acl.addAccessControlEntry(this.testPrincipal, new Privilege[]{privilege2});
        List currentPrivileges = AccessControlListTest.currentPrivileges(acl, this.testPrincipal);
        AccessControlListTest.assertTrue((String)"'AccessControlList.addAccessControlEntry' must not remove privileges added before", (boolean)currentPrivileges.containsAll(twoPrivs));
    }
}

