/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.NamedAccessControlPolicy;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlPolicyTest
extends AbstractAccessControlTest {
    private static Logger log = LoggerFactory.getLogger((Class)AccessControlPolicyTest.class);
    private String path;
    private Map addedPolicies = new HashMap();

    protected void setUp() throws Exception {
        super.setUp();
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        this.path = n.getPath();
    }

    protected void tearDown() throws Exception {
        try {
            Iterator it = this.addedPolicies.keySet().iterator();
            while (it.hasNext()) {
                String path = it.next().toString();
                AccessControlPolicy policy = (AccessControlPolicy)this.addedPolicies.get(path);
                this.acMgr.removePolicy(path, policy);
            }
            this.superuser.save();
        }
        catch (Exception e) {
            log.error("Unexpected error while removing test policies.", (Throwable)e);
        }
        this.addedPolicies.clear();
        super.tearDown();
    }

    public void testGetEffectivePolicies() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        AccessControlPolicy[] policies = this.acMgr.getEffectivePolicies(this.path);
        if (policies == null || policies.length == 0) {
            AccessControlPolicyTest.fail((String)"To every existing node at least a single effective policy applies.");
        }
    }

    public void testGetEffectivePoliciesForNonExistingNode() throws RepositoryException, AccessDeniedException, NotExecutableException {
        String path = this.getPathToNonExistingNode();
        try {
            this.acMgr.getEffectivePolicies(path);
            AccessControlPolicyTest.fail((String)"AccessControlManager.getEffectivePolicy for an invalid absPath must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testGetEffectivePoliciesForProperty() throws RepositoryException, AccessDeniedException, NotExecutableException {
        String path = this.getPathToProperty();
        try {
            this.acMgr.getEffectivePolicies(path);
            AccessControlPolicyTest.fail((String)"AccessControlManager.getEffectivePolicy for property must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testGetPolicies() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        AccessControlPolicy[] policies = this.acMgr.getPolicies(this.path);
        AccessControlPolicyTest.assertNotNull((String)"AccessControlManager.getPolicies must never return null.", (Object)policies);
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i] instanceof NamedAccessControlPolicy) {
                AccessControlPolicyTest.assertNotNull((String)"The name of an NamedAccessControlPolicy must not be null.", (Object)((NamedAccessControlPolicy)policies[i]).getName());
                continue;
            }
            if (!(policies[i] instanceof AccessControlList)) continue;
            AccessControlPolicyTest.assertNotNull((String)"The entries of an AccessControlList must not be null.", (Object)((AccessControlList)policies[i]).getAccessControlEntries());
        }
    }

    public void testGetApplicablePolicies() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        AccessControlPolicyTest.assertNotNull((String)"The iterator of applicable policies must not be null", (Object)it);
    }

    public void testApplicablePoliciesAreDistinct() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        HashSet<AccessControlPolicy> acps = new HashSet<AccessControlPolicy>();
        while (it.hasNext()) {
            AccessControlPolicy policy = it.nextAccessControlPolicy();
            if (acps.add(policy)) continue;
            AccessControlPolicyTest.fail((String)("The applicable policies present should be unique among the choices. Policy " + policy + " occured multiple times."));
        }
    }

    public void testApplicablePoliciesAreDistintFromSetPolicies() throws RepositoryException, NotExecutableException {
        this.checkCanReadAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        HashSet<AccessControlPolicy> acps = new HashSet<AccessControlPolicy>();
        while (it.hasNext()) {
            acps.add(it.nextAccessControlPolicy());
        }
        AccessControlPolicy[] policies = this.acMgr.getPolicies(this.path);
        for (int i = 0; i < policies.length; ++i) {
            AccessControlPolicyTest.assertFalse((String)"The applicable policies obtained should not be present among the policies obtained through AccessControlManager.getPolicies.", (boolean)acps.contains(policies[i]));
        }
    }

    public void testSetPolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanModifyAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (!it.hasNext()) {
            throw new NotExecutableException();
        }
        AccessControlPolicy policy = it.nextAccessControlPolicy();
        this.acMgr.setPolicy(this.path, policy);
    }

    public void testSetIllegalPolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanModifyAc(this.path);
        try {
            this.acMgr.setPolicy(this.path, new AccessControlPolicy(){});
            AccessControlPolicyTest.fail((String)"SetPolicy with an unknown policy should throw AccessControlException.");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void testSetAllPolicies() throws RepositoryException, NotExecutableException {
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (!it.hasNext()) {
            throw new NotExecutableException();
        }
        while (it.hasNext()) {
            this.acMgr.setPolicy(this.path, it.nextAccessControlPolicy());
        }
        it = this.acMgr.getApplicablePolicies(this.path);
        AccessControlPolicyTest.assertFalse((String)"After having set all applicable policies AccessControlManager.getApplicablePolicies should return an empty iterator.", (boolean)it.hasNext());
        AccessControlPolicyTest.assertEquals((String)"After having set all applicable policies AccessControlManager.getApplicablePolicies should return an empty iterator.", (long)0L, (long)it.getSize());
    }

    public void testGetPolicyAfterSet() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        this.checkCanModifyAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (it.hasNext()) {
            AccessControlPolicy policy = it.nextAccessControlPolicy();
            this.acMgr.setPolicy(this.path, policy);
            AccessControlPolicy[] policies = this.acMgr.getPolicies(this.path);
            for (int i = 0; i < policies.length; ++i) {
                if (!policy.equals(policies[i])) continue;
                return;
            }
        } else {
            throw new NotExecutableException();
        }
        AccessControlPolicyTest.fail((String)"GetPolicies must at least return the policy that has been set before.");
    }

    public void testResetPolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        this.checkCanModifyAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (it.hasNext()) {
            AccessControlPolicy policy = it.nextAccessControlPolicy();
            this.acMgr.setPolicy(this.path, policy);
        }
        AccessControlPolicy[] policies = this.acMgr.getPolicies(this.path);
        for (int i = 0; i < policies.length; ++i) {
            this.acMgr.setPolicy(this.path, policies[i]);
        }
    }

    public void testSetPolicyIsTransient() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanModifyAc(this.path);
        List<AccessControlPolicy> currentPolicies = Arrays.asList(this.acMgr.getPolicies(this.path));
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (it.hasNext()) {
            AccessControlPolicy policy = it.nextAccessControlPolicy();
            this.acMgr.setPolicy(this.path, policy);
            this.superuser.refresh(false);
            String mgs = "Reverting 'setPolicy' must change back the return value of getPolicies.";
            if (currentPolicies.isEmpty()) {
                AccessControlPolicyTest.assertTrue((String)mgs, (this.acMgr.getPolicies(this.path).length == 0 ? 1 : 0) != 0);
            } else {
                AccessControlPolicyTest.assertEquals((String)mgs, currentPolicies, Arrays.asList(this.acMgr.getPolicies(this.path)));
            }
        } else {
            throw new NotExecutableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testGetPolicyAfterSave() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        this.checkCanModifyAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (!it.hasNext()) {
            throw new NotExecutableException();
        }
        AccessControlPolicy policy = it.nextAccessControlPolicy();
        this.acMgr.setPolicy(this.path, policy);
        this.superuser.save();
        this.addedPolicies.put(this.path, policy);
        Session s2 = null;
        try {
            s2 = this.getHelper().getSuperuserSession();
            List<AccessControlPolicy> plcs = Arrays.asList(AccessControlPolicyTest.getAccessControlManager(s2).getPolicies(this.path));
            AccessControlPolicyTest.assertTrue((String)"Policy must be visible to another superuser session.", (boolean)plcs.contains(policy));
            Object var6_5 = null;
            if (s2 == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (s2 == null) throw throwable;
            s2.logout();
            throw throwable;
        }
        s2.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeIsModifiedAfterSecondSetPolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanModifyAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (!it.hasNext()) {
            throw new NotExecutableException();
        }
        AccessControlPolicy policy = it.nextAccessControlPolicy();
        this.acMgr.setPolicy(this.path, policy);
        this.superuser.save();
        this.addedPolicies.put(this.path, policy);
        it = this.acMgr.getApplicablePolicies(this.path);
        try {
            if (!it.hasNext()) {
                throw new NotExecutableException();
            }
            Item item = this.superuser.getItem(this.path);
            AccessControlPolicy policy2 = it.nextAccessControlPolicy();
            this.acMgr.setPolicy(this.path, policy2);
            AccessControlPolicyTest.assertTrue((String)"After setting a policy the node must be marked modified.", (boolean)item.isModified());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.superuser.refresh(false);
            throw throwable;
        }
        this.superuser.refresh(false);
    }

    public void testNodeIsModifiedAfterSetPolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanModifyAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (!it.hasNext()) {
            throw new NotExecutableException();
        }
        Item item = this.superuser.getItem(this.path);
        AccessControlPolicy policy = it.nextAccessControlPolicy();
        this.acMgr.setPolicy(this.path, policy);
        AccessControlPolicyTest.assertTrue((String)"After setting a policy the node must be marked modified.", (boolean)item.isModified());
    }

    public void testRemovePolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanModifyAc(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        if (it.hasNext()) {
            AccessControlPolicy policy = it.nextAccessControlPolicy();
            this.acMgr.setPolicy(this.path, policy);
            this.acMgr.removePolicy(this.path, policy);
            AccessControlPolicy[] plcs = this.acMgr.getPolicies(this.path);
            for (int i = 0; i < plcs.length; ++i) {
                if (!plcs[i].equals(policy)) continue;
                AccessControlPolicyTest.fail((String)"RemovePolicy must remove the policy that has been set before.");
            }
        } else {
            throw new NotExecutableException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testRemovePolicyIsTransient() throws RepositoryException, AccessDeniedException, NotExecutableException {
        AccessControlPolicy toRemove;
        this.checkCanReadAc(this.path);
        this.checkCanModifyAc(this.path);
        AccessControlPolicy[] currentPolicies = this.acMgr.getPolicies(this.path);
        int size = currentPolicies.length;
        if (size == 0) {
            AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
            if (!it.hasNext()) throw new NotExecutableException();
            AccessControlPolicy policy = it.nextAccessControlPolicy();
            this.acMgr.setPolicy(this.path, policy);
            this.superuser.save();
            this.addedPolicies.put(this.path, policy);
            toRemove = policy;
            currentPolicies = this.acMgr.getPolicies(this.path);
            size = currentPolicies.length;
        } else {
            toRemove = currentPolicies[0];
        }
        this.acMgr.removePolicy(this.path, toRemove);
        AccessControlPolicyTest.assertEquals((String)"After transient remove AccessControlManager.getPolicies must return less policies.", (int)(size - 1), (int)this.acMgr.getPolicies(this.path).length);
        this.superuser.refresh(false);
        AccessControlPolicyTest.assertEquals((String)"Reverting a Policy removal must restore the original state.", Arrays.asList(currentPolicies), Arrays.asList(this.acMgr.getPolicies(this.path)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeIsModifiedAfterRemovePolicy() throws RepositoryException, AccessDeniedException, NotExecutableException {
        this.checkCanReadAc(this.path);
        this.checkCanModifyAc(this.path);
        Item item = this.superuser.getItem(this.path);
        if (this.acMgr.getPolicies(this.path).length == 0) {
            AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
            if (it.hasNext()) {
                AccessControlPolicy policy = it.nextAccessControlPolicy();
                this.acMgr.setPolicy(this.path, policy);
                this.superuser.save();
                this.addedPolicies.put(this.path, policy);
            } else {
                throw new NotExecutableException();
            }
        }
        try {
            AccessControlPolicy[] plcs = this.acMgr.getPolicies(this.path);
            if (plcs.length > 0) {
                this.acMgr.removePolicy(this.path, plcs[0]);
                AccessControlPolicyTest.assertTrue((String)"After removing a policy the node must be marked modified.", (boolean)item.isModified());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            item.refresh(false);
            throw throwable;
        }
        item.refresh(false);
    }

    public void testNullPolicyOnNewNode() throws NotExecutableException, RepositoryException, AccessDeniedException {
        Node n;
        try {
            n = ((Node)this.superuser.getItem(this.path)).addNode(this.nodeName2, this.testNodeType);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        AccessControlPolicyTest.assertTrue((String)"A new Node must not have an access control policy set.", (this.acMgr.getPolicies(n.getPath()).length == 0 ? 1 : 0) != 0);
    }

    public void testSetPolicyOnNewNode() throws NotExecutableException, RepositoryException, AccessDeniedException {
        Node n;
        try {
            n = ((Node)this.superuser.getItem(this.path)).addNode(this.nodeName2, this.testNodeType);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(n.getPath());
        while (it.hasNext()) {
            AccessControlPolicy policy = it.nextAccessControlPolicy();
            this.acMgr.setPolicy(n.getPath(), policy);
            AccessControlPolicy[] plcs = this.acMgr.getPolicies(n.getPath());
            AccessControlPolicyTest.assertNotNull((String)"After calling setPolicy the manager must return a non-null policy array for the new Node.", (Object)plcs);
            AccessControlPolicyTest.assertTrue((String)"After calling setPolicy the manager must return a policy array with a length greater than zero for the new Node.", (plcs.length > 0 ? 1 : 0) != 0);
        }
    }

    public void testRemoveTransientlyAddedPolicy() throws RepositoryException, AccessDeniedException {
        AccessControlPolicy[] ex = this.acMgr.getPolicies(this.path);
        AccessControlPolicyIterator it = this.acMgr.getApplicablePolicies(this.path);
        while (it.hasNext()) {
            AccessControlPolicy policy = it.nextAccessControlPolicy();
            this.acMgr.setPolicy(this.path, policy);
            this.acMgr.removePolicy(this.path, policy);
            String msg = "transiently added AND removing a policy must revert the changes made. ACMgr.getPolicies must then return the original value.";
            AccessControlPolicyTest.assertEquals((String)msg, Arrays.asList(ex), Arrays.asList(this.acMgr.getPolicies(this.path)));
        }
    }
}

