/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeCancelMergeTest
extends AbstractMergeTest {
    Node nodeToMerge;

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
        VersionManager versionManager = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        versionManager.checkout(this.nodeToMerge.getPath());
    }

    protected void tearDown() throws Exception {
        this.nodeToMerge = null;
        super.tearDown();
    }

    public void testMergeNodeCancelMerge() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), true);
        Version[] predecessors = this.nodeToMerge.getBaseVersion().getPredecessors();
        Property mergeFailedProperty = this.nodeToMerge.getProperty(this.jcrMergeFailed);
        Value[] mergeFailedReferences = mergeFailedProperty.getValues();
        for (int i = 0; i < mergeFailedReferences.length; ++i) {
            String uuid = mergeFailedReferences[i].getString();
            this.nodeToMerge.cancelMerge((Version)this.superuser.getNodeByUUID(uuid));
        }
        Version[] predecessorsAfterCancel = this.nodeToMerge.getBaseVersion().getPredecessors();
        MergeCancelMergeTest.assertTrue((predecessors.length == predecessorsAfterCancel.length ? 1 : 0) != 0);
        if (this.nodeToMerge.hasProperty(this.jcrMergeFailed)) {
            Property mergeFailedPropertyAfterCancelMerge = this.nodeToMerge.getProperty(this.jcrMergeFailed);
            Value[] mergeFailedReferencesAfterCancelMerge = mergeFailedPropertyAfterCancelMerge.getValues();
            MergeCancelMergeTest.assertTrue((mergeFailedReferences.length > mergeFailedReferencesAfterCancelMerge.length ? 1 : 0) != 0);
        }
    }

    protected void initNodes() throws RepositoryException {
        VersionManager versionManager = this.testRootNode.getSession().getWorkspace().getVersionManager();
        Node topVNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        topVNode.setProperty(this.propertyName1, topVNode.getName());
        String path = topVNode.getPath();
        this.testRootNode.getSession().save();
        versionManager.checkin(path);
        versionManager.checkout(path);
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), topVNode.getPath(), topVNode.getPath(), true);
        this.log.println(topVNode.getPath() + " cloned on " + this.superuserW2.getWorkspace().getName() + " at " + topVNode.getPath());
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
    }

    public void testMergeNodeCancelMergeJcr2() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        VersionManager vmWsp1 = originalNode.getSession().getWorkspace().getVersionManager();
        String originalPath = originalNode.getPath();
        vmWsp1.checkout(originalPath);
        vmWsp1.checkin(originalPath);
        VersionManager vmWsp2 = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        vmWsp2.checkin(path);
        vmWsp2.checkout(path);
        vmWsp2.merge(path, this.workspace.getName(), true);
        Version[] predecessors = vmWsp2.getBaseVersion(path).getPredecessors();
        Property mergeFailedProperty = this.nodeToMerge.getProperty(this.jcrMergeFailed);
        Value[] mergeFailedReferences = mergeFailedProperty.getValues();
        for (int i = 0; i < mergeFailedReferences.length; ++i) {
            String id = mergeFailedReferences[i].getString();
            vmWsp2.cancelMerge(path, (Version)this.superuser.getNodeByIdentifier(id));
        }
        Version[] predecessorsAfterCancel = vmWsp2.getBaseVersion(path).getPredecessors();
        MergeCancelMergeTest.assertTrue((predecessors.length == predecessorsAfterCancel.length ? 1 : 0) != 0);
        if (this.nodeToMerge.hasProperty(this.jcrMergeFailed)) {
            Property mergeFailedPropertyAfterCancelMerge = this.nodeToMerge.getProperty(this.jcrMergeFailed);
            Value[] mergeFailedReferencesAfterCancelMerge = mergeFailedPropertyAfterCancelMerge.getValues();
            MergeCancelMergeTest.assertTrue((mergeFailedReferences.length > mergeFailedReferencesAfterCancelMerge.length ? 1 : 0) != 0);
        }
    }
}

