/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractOnParentVersionTest;

public class OnParentVersionIgnoreTest
extends AbstractOnParentVersionTest {
    protected void setUp() throws Exception {
        this.OPVAction = 5;
        super.setUp();
    }

    public void testRestoreProp() throws RepositoryException {
        Node propParent = this.p.getParent();
        propParent.checkout();
        Version v = propParent.checkin();
        propParent.checkout();
        this.p.setValue(this.newPropValue);
        this.p.save();
        propParent.restore(v, false);
        OnParentVersionIgnoreTest.assertEquals((String)"On restore of a OnParentVersion-IGNORE property P, the current value of P must be left unchanged.", (String)this.p.getString(), (String)this.newPropValue);
    }

    public void testRestorePropJcr2() throws RepositoryException {
        Node propParent = this.p.getParent();
        VersionManager versionManager = propParent.getSession().getWorkspace().getVersionManager();
        String path = propParent.getPath();
        versionManager.checkout(path);
        Version v = versionManager.checkin(path);
        versionManager.checkout(path);
        this.p.setValue(this.newPropValue);
        this.p.getSession().save();
        versionManager.restore(v, false);
        OnParentVersionIgnoreTest.assertEquals((String)"On restore of a OnParentVersion-IGNORE property P, the current value of P must be left unchanged.", (String)this.p.getString(), (String)this.newPropValue);
    }

    public void testRestoreNode() throws RepositoryException {
        this.versionableNode.checkout();
        Version v = this.versionableNode.checkin();
        this.versionableNode.checkout();
        String childName = this.addChildNode(this.OPVAction).getName();
        this.versionableNode.save();
        this.versionableNode.restore(v, false);
        if (!this.versionableNode.hasNode(childName)) {
            OnParentVersionIgnoreTest.fail((String)"On restore of a OnParentVersion-Ignore child node, the node needs to be untouched.");
        }
    }

    public void testRestoreNodeJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        versionManager.checkout(path);
        Version v = versionManager.checkin(path);
        versionManager.checkout(path);
        String childName = this.addChildNode(this.OPVAction).getName();
        this.versionableNode.getSession().save();
        versionManager.restore(v, false);
        if (!this.versionableNode.hasNode(childName)) {
            OnParentVersionIgnoreTest.fail((String)"On restore of a OnParentVersion-Ignore child node, the node needs to be untouched.");
        }
    }
}

