/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import junit.framework.Assert;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class VersionHistoryTest
extends AbstractVersionTest {
    protected VersionHistory vHistory;
    private Version version;
    private VersionManager versionManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        this.version = this.versionManager.checkin(this.versionableNode.getPath());
        this.vHistory = this.versionManager.getVersionHistory(this.versionableNode.getPath());
        if (this.vHistory == null) {
            VersionHistoryTest.fail((String)"VersionHistory must be created on persistent creation of a versionable node.");
        }
    }

    protected void tearDown() throws Exception {
        this.vHistory = null;
        this.version = null;
        super.tearDown();
    }

    public void testAutocreatedRootVersion() throws RepositoryException {
        Version rootVersion = this.vHistory.getRootVersion();
        if (rootVersion == null) {
            VersionHistoryTest.fail((String)"The version history must contain an autocreated root version");
        }
    }

    public void testInitialNumberOfVersions() throws RepositoryException {
        long initialSize = this.getNumberOfVersions(this.vHistory);
        VersionHistoryTest.assertEquals((String)"VersionHistory.getAllVersions() initially returns an iterator with two versions.", (long)2L, (long)initialSize);
    }

    public void testInitialNumberOfLinearVersions() throws RepositoryException {
        long initialSize = this.getNumberOfVersions(this.vHistory);
        long initialLinearSize = this.getSize((RangeIterator)this.vHistory.getAllLinearVersions());
        long initialLinearFrozenSize = this.getSize((RangeIterator)this.vHistory.getAllLinearFrozenNodes());
        VersionHistoryTest.assertEquals((String)"VersionHistory.getAllVersions() and .getAllLinearVersions should return the same number of versions for a purely linear version history.", (long)initialSize, (long)initialLinearSize);
        VersionHistoryTest.assertEquals((String)"VersionHistory.getAllVersions() and .getAllLinearFrozenNodes should return the same number of nodes for a purely linear version history.", (long)initialSize, (long)initialLinearFrozenSize);
    }

    public void testInitiallyGetAllVersionsContainsTheRootVersion() throws RepositoryException {
        Version rootVersion = this.vHistory.getRootVersion();
        boolean isContained = false;
        VersionIterator it = this.vHistory.getAllVersions();
        while (it.hasNext()) {
            isContained |= it.nextVersion().isSame((Item)rootVersion);
        }
        VersionHistoryTest.assertTrue((String)"root version must be part of the version history", (boolean)isContained);
    }

    public void testInitiallyGetAllLinearVersionsContainsTheRootAndTheBaseVersion() throws RepositoryException {
        VersionManager vm = this.versionableNode.getSession().getWorkspace().getVersionManager();
        ArrayList<String> lvh = new ArrayList<String>();
        VersionIterator it = this.vHistory.getAllLinearVersions();
        while (it.hasNext()) {
            lvh.add(it.nextVersion().getName());
        }
        String rootVersion = vm.getVersionHistory(this.versionableNode.getPath()).getRootVersion().getName();
        String baseVersion = vm.getBaseVersion(this.versionableNode.getPath()).getName();
        VersionHistoryTest.assertTrue((String)("root version " + rootVersion + " must be part of the linear version history: " + lvh), (boolean)lvh.contains(rootVersion));
        VersionHistoryTest.assertTrue((String)("base version " + baseVersion + " must be part of the linear version history: " + lvh), (boolean)lvh.contains(baseVersion));
    }

    public void testGetAllVersions() throws RepositoryException {
        int cnt = 5;
        HashMap<String, Version> versions = new HashMap<String, Version>();
        Version v = this.vHistory.getRootVersion();
        versions.put(v.getUUID(), v);
        for (int i = 0; i < cnt; ++i) {
            v = this.versionableNode.checkin();
            versions.put(v.getUUID(), v);
            this.versionableNode.checkout();
        }
        VersionIterator it = this.vHistory.getAllVersions();
        while (it.hasNext()) {
            v = it.nextVersion();
            if (!versions.containsKey(v.getUUID())) {
                VersionHistoryTest.fail((String)"VersionHistory.getAllVersions() must only contain the root version and versions, that have been created by a Node.checkin() call.");
            }
            versions.remove(v.getUUID());
        }
        VersionHistoryTest.assertTrue((String)"VersionHistory.getAllVersions() must contain the root version and all versions that have been created with a Node.checkin() call.", (boolean)versions.isEmpty());
    }

    public void testGetAllVersionsJcr2() throws RepositoryException {
        int cnt = 5;
        HashMap<String, Version> versions = new HashMap<String, Version>();
        Version v = this.vHistory.getRootVersion();
        versions.put(v.getIdentifier(), v);
        for (int i = 0; i < cnt; ++i) {
            v = this.versionManager.checkin(this.versionableNode.getPath());
            versions.put(v.getIdentifier(), v);
            this.versionManager.checkout(this.versionableNode.getPath());
        }
        VersionIterator it = this.vHistory.getAllVersions();
        while (it.hasNext()) {
            v = it.nextVersion();
            if (!versions.containsKey(v.getIdentifier())) {
                VersionHistoryTest.fail((String)"VersionHistory.getAllVersions() must only contain the root version and versions, that have been created by a Node.checkin() call.");
            }
            versions.remove(v.getIdentifier());
        }
        VersionHistoryTest.assertTrue((String)"VersionHistory.getAllVersions() must contain the root version and all versions that have been created with a Node.checkin() call.", (boolean)versions.isEmpty());
    }

    public void testGetAllFrozenNodes() throws RepositoryException {
        VersionManager vm = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        int cnt = 2;
        for (int i = 0; i < cnt; ++i) {
            vm.checkpoint(path);
        }
        HashSet<String> frozenIds = new HashSet<String>();
        VersionIterator it = vm.getVersionHistory(path).getAllVersions();
        while (it.hasNext()) {
            Version v = it.nextVersion();
            frozenIds.add(v.getFrozenNode().getIdentifier());
        }
        HashSet<String> test = new HashSet<String>();
        NodeIterator it2 = this.vHistory.getAllFrozenNodes();
        while (it2.hasNext()) {
            Node n = it2.nextNode();
            VersionHistoryTest.assertTrue((String)("Node " + n.getPath() + " must be of type frozen node"), (boolean)n.isNodeType("nt:frozenNode"));
            test.add(n.getIdentifier());
        }
        VersionHistoryTest.assertEquals((String)"getAllFrozenNodes must return the IDs of all frozen nodes", frozenIds, test);
    }

    public void testGetVersionHistoryOnNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.getVersionHistory();
            VersionHistoryTest.fail((String)"Node.getVersionHistory() must throw UnsupportedRepositoryOperationException if the node is not versionable.");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetVersionHistoryOnNonVersionableNodeJcr2() throws RepositoryException {
        try {
            this.versionManager.getVersionHistory(this.nonVersionableNode.getPath());
            VersionHistoryTest.fail((String)"Node.getVersionHistory() must throw UnsupportedRepositoryOperationException if the node is not versionable.");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetVersion() throws RepositoryException {
        Version v = this.versionManager.checkin(this.versionableNode.getPath());
        Version v2 = this.vHistory.getVersion(v.getName());
        VersionHistoryTest.assertTrue((String)"VersionHistory.getVersion(String versionName) must return the version that is identified by the versionName specified, if versionName is the name of a version created by Node.checkin().", (boolean)v.isSame((Item)v2));
    }

    public void testAccept() throws Exception {
        ItemVisitorTest ivt = new ItemVisitorTest(this.vHistory);
        this.vHistory.accept((ItemVisitor)ivt);
    }

    public void testAddMixin() throws Exception {
        try {
            this.vHistory.addMixin(this.mixVersionable);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.addMixin(String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testAddNode() throws Exception {
        try {
            this.vHistory.addNode(this.nodeName4);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.addNode(String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.addNode(this.nodeName4, this.ntBase);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.addNode(String,String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testCanAddMixin() throws Exception {
        VersionHistoryTest.assertFalse((String)"VersionHistory should be read-only: VersionHistory.canAddMixin(String) returned true", (boolean)this.vHistory.canAddMixin(this.mixVersionable));
    }

    public void testCancelMerge() throws Exception {
        try {
            this.vHistory.cancelMerge(this.version);
            VersionHistoryTest.fail((String)"VersionHistory.cancelMerge(Version) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCancelMergeJcr2() throws Exception {
        try {
            this.versionManager.cancelMerge(this.vHistory.getPath(), this.version);
            VersionHistoryTest.fail((String)"VersionHistory.cancelMerge(Version) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckin() throws Exception {
        try {
            this.vHistory.checkin();
            VersionHistoryTest.fail((String)"VersionHistory.checkin() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckinJcr2() throws Exception {
        try {
            this.versionManager.checkin(this.vHistory.getPath());
            VersionHistoryTest.fail((String)"VersionHistory.checkin() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckout() throws Exception {
        try {
            this.vHistory.checkout();
            VersionHistoryTest.fail((String)"VersionHistory.checkout() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckoutJcr2() throws Exception {
        try {
            this.versionManager.checkout(this.vHistory.getPath());
            VersionHistoryTest.fail((String)"VersionHistory.checkout() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testDoneMerge() throws Exception {
        try {
            this.vHistory.doneMerge(this.version);
            VersionHistoryTest.fail((String)"VersionHistory should not be versionable: VersionHistory.doneMerge(Version) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testDoneMergeJcr2() throws Exception {
        try {
            this.versionManager.doneMerge(this.vHistory.getPath(), this.version);
            VersionHistoryTest.fail((String)"VersionHistory should not be versionable: VersionHistory.doneMerge(Version) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetAncestor() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.getAncestor(int) does not work", (boolean)this.superuser.getRootNode().isSame(this.vHistory.getAncestor(0)));
    }

    public void testGetBaseVersion() throws Exception {
        try {
            this.vHistory.getBaseVersion();
            VersionHistoryTest.fail((String)"VersionHistory.getBaseVersion() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetBaseVersionJcr2() throws Exception {
        try {
            this.versionManager.getBaseVersion(this.vHistory.getPath());
            VersionHistoryTest.fail((String)"VersionHistory.getBaseVersion() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetCorrespondingNodePath() throws Exception {
        VersionHistoryTest.assertEquals((String)"VersionHistory.getCorrespondingNodePath(String) did not return the right path", (String)this.vHistory.getPath(), (String)this.vHistory.getCorrespondingNodePath(this.workspaceName));
    }

    public void testGetDepth() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.getDepth() mismatch", (this.vHistory.getDepth() >= 3 ? 1 : 0) != 0);
    }

    public void testGetIndex() throws Exception {
        VersionHistoryTest.assertEquals((String)"VersionHistory.getIndex() mismatch", (int)1, (int)this.vHistory.getIndex());
    }

    public void testGetLock() throws Exception {
        try {
            this.vHistory.getLock();
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.getLock() did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testGetLockJcr2() throws Exception {
        try {
            this.vHistory.getSession().getWorkspace().getLockManager().getLock(this.vHistory.getPath());
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.getLock() did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testGetMixinNodeTypes() throws Exception {
        NodeType[] ntArray = this.vHistory.getMixinNodeTypes();
        VersionHistoryTest.assertNotNull((String)"VersionHistory.getMixinNodeTypes() returns null array", (Object)ntArray);
    }

    public void testGetName() throws Exception {
        VersionHistoryTest.assertEquals((String)"VersionHistory.getName() does not return the right name", (String)this.version.getParent().getName(), (String)this.vHistory.getName());
    }

    public void testGetNode() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.getNode(String) does not return a sub-node of type nt:version", (boolean)this.vHistory.getNode(this.jcrRootVersion).isNodeType(this.ntVersion));
    }

    public void testGetNodes() throws Exception {
        Node n = this.vHistory.getNodes().nextNode();
        VersionHistoryTest.assertTrue((String)"VersionHistory.getNodes() does not return a sub-node of type nt:version", (n.isNodeType(this.ntVersion) || n.isNodeType(this.ntVersionLabels) ? 1 : 0) != 0);
        VersionHistoryTest.assertTrue((String)"VersionHistory.getNodes(String) does not return a sub-node of type nt:version", (boolean)this.vHistory.getNodes(this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":r*").nextNode().isNodeType(this.ntVersion));
    }

    public void testGetParent() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.getParent() does not return the right parent-node", (boolean)this.version.getAncestor(this.version.getDepth() - 2).isSame((Item)this.vHistory.getParent()));
    }

    public void testGetPath() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.getPath() does not return the right path", (boolean)this.vHistory.getPath().startsWith("/" + this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":system/" + this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":versionStorage/"));
    }

    public void testGetPrimaryItem() throws Exception {
        try {
            this.vHistory.getPrimaryItem();
            VersionHistoryTest.fail((String)"VersionHistory.getPrimaryItem() did not throw a ItemNotFoundException");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testGetPrimaryNodeType() throws Exception {
        VersionHistoryTest.assertEquals((String)"VersionHistory does not have the primary node type nt:versionHistory", (String)this.ntVersionHistory, (String)this.vHistory.getPrimaryNodeType().getName());
    }

    public void testGetProperties() throws Exception {
        PropertyIterator pi = this.vHistory.getProperties();
        boolean hasPropertyUUID = false;
        while (pi.hasNext()) {
            if (!pi.nextProperty().getName().equals(this.jcrUUID)) continue;
            hasPropertyUUID = true;
        }
        VersionHistoryTest.assertTrue((String)"VersionHistory.getProperties() does not return property jcr:UUID", (boolean)hasPropertyUUID);
        pi = this.vHistory.getProperties(this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":*");
        hasPropertyUUID = false;
        while (pi.hasNext()) {
            if (!pi.nextProperty().getName().equals(this.jcrUUID)) continue;
            hasPropertyUUID = true;
        }
        VersionHistoryTest.assertTrue((String)"VersionHistory.getProperties(String) does not return property jcr:UUID", (boolean)hasPropertyUUID);
    }

    public void testGetProperty() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.getProperty(String) does not return property jcr:UUID", (boolean)this.vHistory.getProperty(this.jcrUUID).getName().equals(this.jcrUUID));
    }

    public void testGetReferences() throws Exception {
        PropertyIterator pi = this.vHistory.getReferences();
        boolean hasNodeReference = false;
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            if (!p.getName().equals(this.jcrVersionHistory) || !this.superuser.getNodeByUUID(p.getString()).isSame((Item)this.vHistory)) continue;
            hasNodeReference = true;
            break;
        }
        VersionHistoryTest.assertTrue((String)"VersionHistory.getReferences() does not return the jcr:versionHistory property of the versioned Node", (boolean)hasNodeReference);
    }

    public void testGetSession() throws Exception {
        VersionHistoryTest.assertSame((String)"VersionHistory.getSession() did not return the right session", (Object)this.superuser, (Object)this.vHistory.getSession());
    }

    public void testGetUUID() throws Exception {
        VersionHistoryTest.assertEquals((String)"VersionHistory.getUUID() did not return the right UUID", (String)this.versionableNode.getProperty(this.jcrVersionHistory).getString(), (String)this.vHistory.getUUID());
    }

    public void testGetIdentifier() throws Exception {
        VersionHistoryTest.assertEquals((String)"VersionHistory.getIdentifier() did not return the right Id", (String)this.versionableNode.getProperty(this.jcrVersionHistory).getString(), (String)this.vHistory.getIdentifier());
    }

    public void testGetVersionHistory() throws Exception {
        try {
            this.vHistory.getVersionHistory();
            VersionHistoryTest.fail((String)"VersionHistory.getVersionHistory() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetVersionHistoryJcr2() throws Exception {
        try {
            this.versionManager.getVersionHistory(this.vHistory.getPath());
            VersionHistoryTest.fail((String)"VersionHistory.getVersionHistory() did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testHasNode() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.hasNode(String) did not return true", (boolean)this.vHistory.hasNode(this.jcrRootVersion));
    }

    public void testHasNodes() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.hasNodes() did not return true", (boolean)this.vHistory.hasNodes());
    }

    public void testHasProperties() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.hasProperties() did not return true", (boolean)this.vHistory.hasProperties());
    }

    public void testHasProperty() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.hasProperty(String) did not return true", (boolean)this.vHistory.hasProperty(this.jcrUUID));
    }

    public void testHoldsLock() throws Exception {
        VersionHistoryTest.assertFalse((String)"VersionHistory.holdsLock() did not return false", (boolean)this.vHistory.holdsLock());
    }

    public void testHoldsLockJcr2() throws Exception {
        VersionHistoryTest.assertFalse((String)"VersionHistory.holdsLock() did not return false", (boolean)this.vHistory.getSession().getWorkspace().getLockManager().holdsLock(this.vHistory.getPath()));
    }

    public void testIsCheckedOut() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.isCheckedOut() did not return true", (boolean)this.vHistory.isCheckedOut());
    }

    public void testIsCheckedOutJcr2() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.isCheckedOut() did not return true", (boolean)this.versionManager.isCheckedOut(this.vHistory.getPath()));
    }

    public void testIsLocked() throws Exception {
        VersionHistoryTest.assertFalse((String)"VersionHistory.isLocked() did not return false", (boolean)this.vHistory.isLocked());
    }

    public void testIsLockedJcr2() throws Exception {
        VersionHistoryTest.assertFalse((String)"VersionHistory.isLocked() did not return false", (boolean)this.vHistory.getSession().getWorkspace().getLockManager().isLocked(this.vHistory.getPath()));
    }

    public void testIsModified() throws Exception {
        VersionHistoryTest.assertFalse((String)"VersionHistory.isModified() did not return false", (boolean)this.vHistory.isModified());
    }

    public void testIsNew() throws Exception {
        VersionHistoryTest.assertFalse((String)"VersionHistory.isNew() did not return false", (boolean)this.vHistory.isNew());
    }

    public void testIsNode() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.isNode() did not return true", (boolean)this.vHistory.isNode());
    }

    public void testIsNodeType() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.isNodeType(String) did not return true for nt:versionHistory", (boolean)this.vHistory.isNodeType(this.ntVersionHistory));
    }

    public void testIsSame() throws Exception {
        VersionHistoryTest.assertTrue((String)"VersionHistory.isSame(Item) did not return true", (boolean)this.vHistory.isSame((Item)this.version.getParent()));
    }

    public void testLock() throws Exception {
        try {
            this.vHistory.lock(true, true);
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.lock(true,true) did not throw a LockException");
        }
        catch (LockException success) {
            // empty catch block
        }
        try {
            this.vHistory.lock(true, false);
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.lock(true,false) did not throw a LockException");
        }
        catch (LockException success) {
            // empty catch block
        }
        try {
            this.vHistory.lock(false, true);
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.lock(false,true) did not throw a LockException");
        }
        catch (LockException success) {
            // empty catch block
        }
        try {
            this.vHistory.lock(false, false);
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.lock(false,false) did not throw a UnsupportedRepositoryOperationException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testLockJcr2() throws Exception {
        LockManager lockManager = this.vHistory.getSession().getWorkspace().getLockManager();
        String path = this.vHistory.getPath();
        try {
            lockManager.lock(path, true, true, 60L, "");
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.lock(true,true) did not throw a LockException");
        }
        catch (LockException success) {
            // empty catch block
        }
        try {
            lockManager.lock(path, true, false, 60L, "");
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.lock(true,false) did not throw a LockException");
        }
        catch (LockException success) {
            // empty catch block
        }
        try {
            lockManager.lock(path, false, true, 60L, "");
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.lock(false,true) did not throw a LockException");
        }
        catch (LockException success) {
            // empty catch block
        }
        try {
            lockManager.lock(path, false, false, 60L, "");
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.lock(false,false) did not throw a UnsupportedRepositoryOperationException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testMerge() throws Exception {
        try {
            this.vHistory.merge(this.workspaceName, true);
            VersionHistoryTest.fail((String)"VersionHistory.merge(String, true) did not throw an ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.merge(this.workspaceName, false);
            VersionHistoryTest.fail((String)"VersionHistory.merge(String, false) did not throw an ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testOrderBefore() throws Exception {
        try {
            this.vHistory.orderBefore(this.jcrFrozenNode, null);
            VersionHistoryTest.fail((String)"VersionHistory.orderBefore(String,String) did not throw an UnsupportedRepositoryOperationException or a ConstraintViolationException");
        }
        catch (UnsupportedRepositoryOperationException success) {
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testRefresh() throws Exception {
        this.vHistory.refresh(true);
        this.vHistory.refresh(false);
    }

    public void testRemove() throws Exception {
        try {
            Node vHistoryParent = this.vHistory.getParent();
            this.vHistory.remove();
            vHistoryParent.save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.remove() did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testRemoveMixin() throws Exception {
        try {
            this.vHistory.removeMixin(this.mixReferenceable);
            VersionHistoryTest.fail((String)"VersionHistory does not have mixins: VersionHistory.removeMixin(String) did not throw a NoSuchNodeTypeException.");
        }
        catch (ConstraintViolationException success) {
        }
        catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            // empty catch block
        }
    }

    public void testRestore() throws Exception {
        try {
            this.vHistory.restore("abc", true);
            VersionHistoryTest.fail((String)"VersionHistory.restore(String,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException success) {
            // empty catch block
        }
        try {
            this.vHistory.restore(this.version, true);
            VersionHistoryTest.fail((String)"VersionHistory.restore(Version,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException success) {
            // empty catch block
        }
        try {
            this.vHistory.restore(this.version, "abc", true);
            VersionHistoryTest.fail((String)"VersionHistory.restore(Version,String,boolean) did not throw an ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testRestoreJcr2() throws Exception {
        try {
            this.versionManager.restore(this.vHistory.getPath(), "abc", true);
            VersionHistoryTest.fail((String)"VersionHistory.restore(String,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreByLabel() throws Exception {
        try {
            this.vHistory.restoreByLabel("abc", true);
            VersionHistoryTest.fail((String)"VersionHistory.restoreByLabel(String,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreByLabelJcr2() throws Exception {
        try {
            this.versionManager.restoreByLabel(this.vHistory.getPath(), "abc", true);
            VersionHistoryTest.fail((String)"VersionHistory.restoreByLabel(String,boolean) did not throw an UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testSetProperty() throws Exception {
        Value[] vArray = new Value[]{this.superuser.getValueFactory().createValue("abc"), this.superuser.getValueFactory().createValue("xyz"), this.superuser.getValueFactory().createValue("123")};
        String[] s = new String[]{"abc", "xyz", "123"};
        try {
            this.vHistory.setProperty(this.propertyName1, s);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,String[]) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.setProperty(this.propertyName1, s, 1);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,String[],int) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.setProperty(this.propertyName1, vArray);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,Value[]) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.setProperty(this.propertyName1, vArray, 1);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,Value[],int]) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.setProperty(this.propertyName1, true);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,boolean) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.setProperty(this.propertyName1, 123L);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,double) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            byte[] bytes = new byte[]{73, 26, 32, -36, 40, -43, -124};
            ByteArrayInputStream inpStream = new ByteArrayInputStream(bytes);
            this.vHistory.setProperty(this.propertyName1, (InputStream)inpStream);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,InputStream) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.setProperty(this.propertyName1, "abc");
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,String) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            GregorianCalendar c = new GregorianCalendar(1945, 1, 6, 16, 20, 0);
            this.vHistory.setProperty(this.propertyName1, (Calendar)c);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,Calendar) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.setProperty(this.propertyName1, (Node)this.vHistory);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,Node) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            Value v = this.superuser.getValueFactory().createValue("abc");
            this.vHistory.setProperty(this.propertyName1, v);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,Value) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException success) {
            // empty catch block
        }
        try {
            this.vHistory.setProperty(this.propertyName1, -2147483650L);
            this.vHistory.getSession().save();
            VersionHistoryTest.fail((String)"VersionHistory should be read-only: VersionHistory.setProperty(String,long) did not throw a ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testUnlock() throws Exception {
        try {
            this.vHistory.unlock();
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.unlock() did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testUnlockJcr2() throws Exception {
        try {
            this.vHistory.getSession().getWorkspace().getLockManager().unlock(this.vHistory.getPath());
            VersionHistoryTest.fail((String)"VersionHistory should not be lockable: VersionHistory.unlock() did not throw a LockException");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testUpdate() throws Exception {
        try {
            this.vHistory.update(this.workspaceName);
            VersionHistoryTest.fail((String)"VersionHistory.update(String) did not throw an ConstraintViolationException");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    private class ItemVisitorTest
    implements ItemVisitor {
        Node ivtNode;

        public ItemVisitorTest(VersionHistory v) {
            this.ivtNode = v;
        }

        public void visit(Node node) throws RepositoryException {
            Assert.assertTrue((String)"VersionHistory.accept(ItemVisitor) does not provide the right node to the ItemVisitor", (boolean)this.ivtNode.isSame((Item)node));
        }

        public void visit(Property property) throws RepositoryException {
        }
    }
}

