/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.util.Calendar;
import java.util.TimeZone;

public final class ISO8601 {
    public static Calendar parse(String text) {
        String tzID;
        int ms;
        int sec;
        int min;
        int hour;
        int day;
        int month;
        int year;
        int sign;
        block21: {
            int start;
            if (text == null) {
                throw new IllegalArgumentException("argument can not be null");
            }
            if (text.startsWith("-")) {
                sign = 45;
                start = 1;
            } else if (text.startsWith("+")) {
                sign = 43;
                start = 1;
            } else {
                sign = 43;
                start = 0;
            }
            try {
                year = Integer.parseInt(text.substring(start, start + 4));
                if (text.charAt(start += 4) != '-') {
                    return null;
                }
                month = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != '-') {
                    return null;
                }
                day = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != 'T') {
                    return null;
                }
                hour = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != ':') {
                    return null;
                }
                min = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != ':') {
                    return null;
                }
                sec = Integer.parseInt(text.substring(++start, start + 2));
                if (text.charAt(start += 2) != '.') {
                    return null;
                }
                ms = Integer.parseInt(text.substring(++start, start + 3));
                if (text.charAt(start += 3) == '+' || text.charAt(start) == '-') {
                    tzID = "GMT" + text.substring(start);
                    break block21;
                }
                if (text.substring(start).equals("Z")) {
                    tzID = "GMT";
                    break block21;
                }
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        TimeZone tz = TimeZone.getTimeZone(tzID);
        if (!tz.getID().equals(tzID)) {
            return null;
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setLenient(false);
        if (sign == 45 || year == 0) {
            cal.set(1, year + 1);
            cal.set(0, 0);
        } else {
            cal.set(1, year);
            cal.set(0, 1);
        }
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, ms);
        try {
            cal.getTime();
            ISO8601.getYear(cal);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return cal;
    }

    public static String format(Calendar cal) throws IllegalArgumentException {
        if (cal == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        StringBuffer buf = new StringBuffer();
        ISO8601.appendZeroPaddedInt(buf, ISO8601.getYear(cal), 4);
        buf.append('-');
        ISO8601.appendZeroPaddedInt(buf, cal.get(2) + 1, 2);
        buf.append('-');
        ISO8601.appendZeroPaddedInt(buf, cal.get(5), 2);
        buf.append('T');
        ISO8601.appendZeroPaddedInt(buf, cal.get(11), 2);
        buf.append(':');
        ISO8601.appendZeroPaddedInt(buf, cal.get(12), 2);
        buf.append(':');
        ISO8601.appendZeroPaddedInt(buf, cal.get(13), 2);
        buf.append('.');
        ISO8601.appendZeroPaddedInt(buf, cal.get(14), 3);
        TimeZone tz = cal.getTimeZone();
        int offset = tz.getOffset(cal.getTimeInMillis());
        if (offset != 0) {
            int hours = Math.abs(offset / 60000 / 60);
            int minutes = Math.abs(offset / 60000 % 60);
            buf.append(offset < 0 ? (char)'-' : '+');
            ISO8601.appendZeroPaddedInt(buf, hours, 2);
            buf.append(':');
            ISO8601.appendZeroPaddedInt(buf, minutes, 2);
        } else {
            buf.append('Z');
        }
        return buf.toString();
    }

    public static int getYear(Calendar cal) throws IllegalArgumentException {
        int year = cal.get(1);
        if (cal.isSet(0) && cal.get(0) == 0) {
            year = 0 - year + 1;
        }
        if (year > 9999 || year < -9999) {
            throw new IllegalArgumentException("Calendar has more than four year digits, cannot be formatted as ISO8601: " + year);
        }
        return year;
    }

    private static void appendZeroPaddedInt(StringBuffer buf, int n, int precision) {
        if (n < 0) {
            buf.append('-');
            n = -n;
        }
        for (int exp = precision - 1; exp > 0 && (double)n < Math.pow(10.0, exp); --exp) {
            buf.append('0');
        }
        buf.append(n);
    }
}

