/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.RepositoryStub;
import org.apache.jackrabbit.test.RepositoryStubException;

public class RepositoryHelper {
    private RepositoryStub repoStub;
    private Map configuration = new HashMap();

    public RepositoryHelper() {
    }

    public RepositoryHelper(Map config) {
        this.configuration.putAll(config);
    }

    public Repository getRepository() throws RepositoryException {
        try {
            if (this.repoStub == null) {
                this.repoStub = RepositoryStub.getInstance(this.configuration);
            }
            return this.repoStub.getRepository();
        }
        catch (RepositoryStubException e) {
            throw new RepositoryException("Failed to get Repository instance.", (Throwable)e);
        }
    }

    public Session getSuperuserSession() throws RepositoryException {
        return this.getSuperuserSession(null);
    }

    public Session getSuperuserSession(String workspaceName) throws RepositoryException {
        return this.getRepository().login(this.repoStub.getSuperuserCredentials(), workspaceName);
    }

    public Session getReadWriteSession() throws RepositoryException {
        return this.getReadWriteSession(null);
    }

    public Session getReadWriteSession(String workspaceName) throws RepositoryException {
        return this.getRepository().login(this.repoStub.getReadWriteCredentials(), workspaceName);
    }

    public Session getReadOnlySession() throws RepositoryException {
        return this.getReadOnlySession(null);
    }

    public Session getReadOnlySession(String workspaceName) throws RepositoryException {
        return this.getRepository().login(this.repoStub.getReadOnlyCredentials(), workspaceName);
    }

    public String getProperty(String name) throws RepositoryException {
        this.getRepository();
        return this.repoStub.getProperty(name);
    }

    public Credentials getReadOnlyCredentials() {
        return this.repoStub.getReadOnlyCredentials();
    }

    public Credentials getReadWriteCredentials() {
        return this.repoStub.getReadWriteCredentials();
    }

    public Credentials getSuperuserCredentials() {
        return this.repoStub.getSuperuserCredentials();
    }

    public Principal getKnownPrincipal(Session session) throws RepositoryException {
        return this.repoStub.getKnownPrincipal(session);
    }

    public Principal getUnknownPrincipal(Session session) throws NotExecutableException, RepositoryException {
        return this.repoStub.getUnknownPrincipal(session);
    }
}

