/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class GetWeakReferencesTest
extends AbstractJCRTest {
    private Node target;
    private Node referring;

    protected void setUp() throws Exception {
        super.setUp();
        this.target = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(this.target, this.mixReferenceable);
        this.referring = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
    }

    public void testSingleValue() throws RepositoryException {
        Value weakRef = this.vf.createValue(this.target, true);
        this.referring.setProperty(this.propertyName1, weakRef);
        this.superuser.save();
        PropertyIterator it = this.target.getWeakReferences();
        GetWeakReferencesTest.assertTrue((String)"no weak references returned", (boolean)it.hasNext());
        Property p = it.nextProperty();
        GetWeakReferencesTest.assertEquals((String)"wrong weak reference property", (String)this.referring.getProperty(this.propertyName1).getPath(), (String)p.getPath());
        GetWeakReferencesTest.assertFalse((String)"no more weak references expected", (boolean)it.hasNext());
    }

    public void testSingleValueWithName() throws RepositoryException {
        Value weakRef = this.vf.createValue(this.target, true);
        this.referring.setProperty(this.propertyName1, weakRef);
        this.superuser.save();
        PropertyIterator it = this.target.getWeakReferences(this.propertyName1);
        GetWeakReferencesTest.assertTrue((String)"no weak references returned", (boolean)it.hasNext());
        Property p = it.nextProperty();
        GetWeakReferencesTest.assertEquals((String)"wrong weak reference property", (String)this.referring.getProperty(this.propertyName1).getPath(), (String)p.getPath());
        GetWeakReferencesTest.assertFalse((String)"no more weak references expected", (boolean)it.hasNext());
    }

    public void testMultiValues() throws RepositoryException {
        Value weakRef = this.vf.createValue(this.target, true);
        Value[] refs = new Value[]{weakRef, weakRef};
        this.referring.setProperty(this.propertyName1, refs);
        this.superuser.save();
        PropertyIterator it = this.target.getWeakReferences();
        GetWeakReferencesTest.assertTrue((String)"no weak references returned", (boolean)it.hasNext());
        Property p = it.nextProperty();
        GetWeakReferencesTest.assertEquals((String)"wrong weak reference property", (String)this.referring.getProperty(this.propertyName1).getPath(), (String)p.getPath());
        GetWeakReferencesTest.assertFalse((String)"no more weak references expected", (boolean)it.hasNext());
    }

    public void testMultiValuesWithName() throws RepositoryException {
        Value weakRef = this.vf.createValue(this.target, true);
        Value[] refs = new Value[]{weakRef, weakRef};
        this.referring.setProperty(this.propertyName1, refs);
        this.superuser.save();
        PropertyIterator it = this.target.getWeakReferences(this.propertyName1);
        GetWeakReferencesTest.assertTrue((String)"no weak references returned", (boolean)it.hasNext());
        Property p = it.nextProperty();
        GetWeakReferencesTest.assertEquals((String)"wrong weak reference property", (String)this.referring.getProperty(this.propertyName1).getPath(), (String)p.getPath());
        GetWeakReferencesTest.assertFalse((String)"no more weak references expected", (boolean)it.hasNext());
    }

    public void testNonReferenceable() throws RepositoryException, NotExecutableException {
        Node nonReferenceable = null;
        if (this.testRootNode.isNodeType(this.mixReferenceable)) {
            Node child = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.superuser.save();
            if (!child.isNodeType(this.mixReferenceable)) {
                nonReferenceable = child;
            }
        } else {
            nonReferenceable = this.testRootNode;
        }
        if (nonReferenceable == null) {
            throw new NotExecutableException("Test node is referenceable.");
        }
        GetWeakReferencesTest.assertFalse((boolean)nonReferenceable.getWeakReferences().hasNext());
    }
}

