/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.NoSuchElementException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeIteratorTest
extends AbstractJCRTest {
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
    }

    public void testGetSize() throws RepositoryException, NotExecutableException {
        long count;
        NodeIterator iter = this.testRootNode.getNodes();
        long size = this.testRootNode.getNodes().getSize();
        if (size != -1L) {
            count = 0L;
            while (iter.hasNext()) {
                iter.nextNode();
                ++count;
            }
        } else {
            throw new NotExecutableException("NodeIterator.getSize() does not return size information.");
        }
        NodeIteratorTest.assertEquals((String)"NodeIterator.getSize does not return correct number.", (long)size, (long)count);
    }

    public void testGetPos() throws RepositoryException {
        NodeIterator iter = this.testRootNode.getNodes();
        NodeIteratorTest.assertEquals((String)"Initial call to getPos() must return zero", (long)0L, (long)iter.getPosition());
        int index = 0;
        while (iter.hasNext()) {
            iter.nextNode();
            NodeIteratorTest.assertEquals((String)"Wrong position returned by getPos()", (long)(++index), (long)iter.getPosition());
        }
    }

    public void testNoSuchElementException() throws RepositoryException {
        NodeIterator iter = this.testRootNode.getNodes();
        while (iter.hasNext()) {
            iter.nextNode();
        }
        try {
            iter.nextNode();
            NodeIteratorTest.fail((String)"nextNode() must throw a NoSuchElementException when no nodes are available");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testSkip() throws RepositoryException {
        NodeIterator iter = this.testRootNode.getNodes();
        int count = 0;
        while (iter.hasNext()) {
            iter.nextNode();
            ++count;
        }
        if (count > 0) {
            iter = this.testRootNode.getNodes();
            iter.skip((long)count);
            try {
                iter.nextNode();
                NodeIteratorTest.fail((String)"nextNode() must throw a NoSuchElementException when no nodes are available");
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            iter = this.testRootNode.getNodes();
            try {
                iter.skip((long)(count + 1));
                NodeIteratorTest.fail((String)"skip() must throw a NoSuchElementException if one tries to skip past the end of the iterator");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }
}

