/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetValueLongTest
extends AbstractJCRTest {
    private Value value;
    private Node node;
    private Property property1;

    protected void setUp() throws Exception {
        super.setUp();
        this.value = this.superuser.getValueFactory().createValue(73057230L);
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.property1 = this.node.setProperty(this.propertyName1, 0L);
        this.superuser.save();
    }

    protected void tearDown() throws Exception {
        this.value = null;
        this.node = null;
        this.property1 = null;
        super.tearDown();
    }

    public void testLongSession() throws RepositoryException {
        this.property1.setValue(this.value);
        this.superuser.save();
        SetValueLongTest.assertEquals((String)"Long property not saved", (long)this.value.getLong(), (long)this.property1.getValue().getLong());
    }

    public void testLongParent() throws RepositoryException {
        this.property1.setValue(this.value.getLong());
        this.node.save();
        SetValueLongTest.assertEquals((String)"Long property not saved", (long)this.value.getLong(), (long)this.property1.getValue().getLong());
    }

    public void testRemoveLongParent() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueLongTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveLongSession() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueLongTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }
}

