/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceSameNameSibsTest;

public class WorkspaceCloneSameNameSibsTest
extends AbstractWorkspaceSameNameSibsTest {
    public void testCloneNodesOrderingSupportedByParent() throws RepositoryException {
        String[] orderList = new String[]{this.nodeName1, this.nodeName2, this.nodeName3};
        for (int i = 0; i < orderList.length; ++i) {
            this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), this.node2.getPath() + "/" + orderList[i], true);
        }
        int cnt = 0;
        NodeIterator iter = this.node2.getNodes();
        while (iter.hasNext()) {
            Node n = iter.nextNode();
            WorkspaceCloneSameNameSibsTest.assertTrue((boolean)n.getName().equals(orderList[cnt]));
            ++cnt;
        }
    }

    public void testCloneNodesNodeExistsAtDestPath() throws RepositoryException {
        Node snsfNode = this.testRootNodeW2.addNode(this.nodeName3, this.sameNameSibsFalseNodeType.getName());
        this.testRootNodeW2.save();
        String dstAbsPath = snsfNode.getPath() + "/" + this.node1W2.getName();
        this.workspaceW2.copy(this.node1W2.getPath(), dstAbsPath);
        try {
            this.workspaceW2.clone(this.workspace.getName(), this.node1.getPath(), dstAbsPath, true);
            WorkspaceCloneSameNameSibsTest.fail((String)("Node exists below '" + dstAbsPath + "'. Test should fail."));
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }
}

