/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventJournal;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;

public class EventJournalTest
extends AbstractObservationTest {
    private EventJournal journal;

    protected void setUp() throws Exception {
        super.setUp();
        this.journal = this.obsMgr.getEventJournal();
    }

    public void testSkipToNow() throws RepositoryException {
        this.skipToNow();
        EventJournalTest.assertFalse((boolean)this.journal.hasNext());
    }

    public void testSkipTo() throws Exception {
        long time = System.currentTimeMillis();
        Node n1 = this.testRootNode.addNode(this.nodeName1);
        Node n2 = this.testRootNode.addNode(this.nodeName2);
        while (time == System.currentTimeMillis()) {
            Thread.sleep(1L);
        }
        this.superuser.save();
        this.journal.skipTo(time);
        this.checkJournal(new String[]{n1.getPath(), n2.getPath()}, new String[0]);
    }

    public void testLiveJournal() throws RepositoryException {
        this.skipToNow();
        EventJournalTest.assertFalse((boolean)this.journal.hasNext());
        this.testRootNode.addNode(this.nodeName1);
        this.superuser.save();
        EventJournalTest.assertTrue((boolean)this.journal.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkspaceSeparation() throws RepositoryException {
        this.skipToNow();
        EventJournalTest.assertFalse((boolean)this.journal.hasNext());
        Session session = this.getHelper().getSuperuserSession(this.workspaceName);
        try {
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(this.nodeName1)) {
                rootNode.getNode(this.nodeName1).remove();
            } else {
                rootNode.addNode(this.nodeName1);
            }
            session.save();
        }
        finally {
            session.logout();
        }
        EventJournalTest.assertFalse((boolean)this.journal.hasNext());
    }

    public void testIsDeepTrue() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1);
        Node n2 = n1.addNode(this.nodeName2);
        this.journal = this.obsMgr.getEventJournal();
        this.skipToNow();
        this.superuser.save();
        this.checkJournal(new String[]{n1.getPath(), n2.getPath()}, new String[0]);
    }

    public void testUUID() throws RepositoryException, NotExecutableException {
        Node n1 = this.testRootNode.addNode(this.nodeName1);
        this.ensureMixinType(n1, this.mixReferenceable);
        this.superuser.save();
        Node n2 = n1.addNode(this.nodeName2);
        this.journal = this.obsMgr.getEventJournal();
        this.skipToNow();
        this.superuser.save();
        this.checkJournal(new String[]{n2.getPath()}, new String[0]);
    }

    public void testUserData() throws RepositoryException {
        this.testRootNode.addNode(this.nodeName1);
        String data = this.createRandomString(5);
        this.obsMgr.setUserData(data);
        this.journal = this.obsMgr.getEventJournal();
        this.skipToNow();
        this.superuser.save();
        EventJournalTest.assertTrue((String)"no more events", (boolean)this.journal.hasNext());
        EventJournalTest.assertEquals((String)"Wrong user data", (String)data, (String)this.journal.nextEvent().getUserData());
    }

    public void testEventType() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1);
        this.journal = this.getEventJournal(4, this.testRoot, true, null, null);
        this.skipToNow();
        this.superuser.save();
        this.checkJournal(new String[]{n1.getPath() + "/" + this.jcrPrimaryType}, new String[]{n1.getPath()});
    }

    public void testPath() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1);
        Node n2 = n1.addNode(this.nodeName2);
        this.journal = this.getEventJournal(63, n1.getPath(), true, null, null);
        this.skipToNow();
        this.superuser.save();
        this.checkJournal(new String[]{n2.getPath()}, new String[]{n1.getPath()});
    }

    public void testIsDeepFalse() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1);
        Node n2 = n1.addNode(this.nodeName2);
        this.journal = this.getEventJournal(63, this.testRoot, false, null, null);
        this.skipToNow();
        this.superuser.save();
        this.checkJournal(new String[]{n1.getPath()}, new String[]{n2.getPath()});
    }

    public void testNodeType() throws RepositoryException {
        Node n1 = this.testRootNode.addNode(this.nodeName1, "nt:folder");
        Node n2 = n1.addNode(this.nodeName2, "nt:folder");
        this.journal = this.getEventJournal(63, this.testRoot, true, null, new String[]{"nt:folder"});
        this.skipToNow();
        this.superuser.save();
        this.checkJournal(new String[]{n2.getPath()}, new String[]{n1.getPath()});
    }

    private void skipToNow() {
        long now = System.currentTimeMillis();
        this.journal.skipTo(now);
        while (now == System.currentTimeMillis()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private EventJournal getEventJournal(int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName) throws RepositoryException {
        return this.superuser.getWorkspace().getObservationManager().getEventJournal(eventTypes, absPath, isDeep, uuid, nodeTypeName);
    }

    private void checkJournal(String[] allowed, String[] denied) throws RepositoryException {
        HashSet<String> allowedSet = new HashSet<String>(Arrays.asList(allowed));
        HashSet<String> deniedSet = new HashSet<String>(Arrays.asList(denied));
        while (this.journal.hasNext()) {
            String path = this.journal.nextEvent().getPath();
            allowedSet.remove(path);
            if (!deniedSet.contains(path)) continue;
            EventJournalTest.fail((String)(path + " must not be present in journal"));
        }
        EventJournalTest.assertTrue((String)("Missing paths in journal: " + allowedSet), (boolean)allowedSet.isEmpty());
    }
}

