/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

public class GetLanguageTest
extends AbstractQueryTest {
    private Session session;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.testRootNode = this.session.getRootNode().getNode(this.testPath);
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testGetLanguage() throws RepositoryException {
        String statement = "/" + this.jcrRoot;
        Query q = this.session.getWorkspace().getQueryManager().createQuery(statement, "xpath");
        GetLanguageTest.assertEquals((String)"Query returns wrong language.", (String)"xpath", (String)q.getLanguage());
    }

    public void testSQL() throws RepositoryException, NotExecutableException {
        if (!this.isSupportedLanguage("sql")) {
            throw new NotExecutableException("SQL not supported");
        }
        String stmt = "select * from " + this.testNodeType;
        Query q = this.session.getWorkspace().getQueryManager().createQuery(stmt, "sql");
        GetLanguageTest.assertEquals((String)"Query returns wrong language.", (String)"sql", (String)q.getLanguage());
    }

    public void testJCRSQL2() throws RepositoryException {
        String stmt = "SELECT * FROM [" + this.testNodeType + "]";
        Query q = this.session.getWorkspace().getQueryManager().createQuery(stmt, "JCR-SQL2");
        GetLanguageTest.assertEquals((String)"Query returns wrong language.", (String)"JCR-SQL2", (String)q.getLanguage());
    }

    public void testJCRQOM() throws RepositoryException {
        QueryObjectModel qom = this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), null, null, null);
        GetLanguageTest.assertEquals((String)"Query returns wrong language.", (String)"JCR-JQOM", (String)qom.getLanguage());
    }
}

