/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.util.Calendar;
import java.util.TimeZone;
import org.apache.jackrabbit.test.api.query.AbstractOrderByTest;

public class OrderByDateTest
extends AbstractOrderByTest {
    public void testDateOrder() throws Exception {
        Calendar c1 = Calendar.getInstance();
        c1.set(2000, 4, 20, 14, 35, 14);
        Calendar c2 = Calendar.getInstance();
        c2.set(2000, 5, 20, 14, 35, 14);
        Calendar c3 = Calendar.getInstance();
        c3.set(2000, 4, 20, 14, 35, 13);
        this.populate(new Calendar[]{c1, c2, c3});
        this.checkOrder(new String[]{this.nodeName3, this.nodeName1, this.nodeName2});
    }

    public void testDateOrderMillis() throws Exception {
        Calendar c1 = Calendar.getInstance();
        c1.set(2000, 6, 12, 14, 35, 19);
        c1.set(14, 10);
        Calendar c2 = Calendar.getInstance();
        c2.set(2000, 6, 12, 14, 35, 19);
        c2.set(14, 9);
        Calendar c3 = Calendar.getInstance();
        c3.set(2000, 6, 12, 14, 35, 19);
        c3.set(14, 11);
        this.populate(new Calendar[]{c1, c2, c3});
        this.checkOrder(new String[]{this.nodeName2, this.nodeName1, this.nodeName3});
    }

    public void testDateOrderPositiveTimeZone() throws Exception {
        Calendar c1 = Calendar.getInstance(TimeZone.getTimeZone("GMT+1:00"));
        c1.set(2000, 6, 12, 15, 35, 19);
        c1.set(14, 10);
        Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c2.set(2000, 6, 12, 14, 35, 19);
        c2.set(14, 9);
        Calendar c3 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c3.set(2000, 6, 12, 14, 35, 19);
        c3.set(14, 11);
        this.populate(new Calendar[]{c1, c2, c3});
        this.checkOrder(new String[]{this.nodeName2, this.nodeName1, this.nodeName3});
    }

    public void testDateOrderNegativeTimeZone() throws Exception {
        Calendar c1 = Calendar.getInstance(TimeZone.getTimeZone("GMT-1:00"));
        c1.set(2000, 6, 12, 13, 35, 19);
        c1.set(14, 10);
        Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c2.set(2000, 6, 12, 14, 35, 19);
        c2.set(14, 9);
        Calendar c3 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c3.set(2000, 6, 12, 14, 35, 19);
        c3.set(14, 11);
        this.populate(new Calendar[]{c1, c2, c3});
        this.checkOrder(new String[]{this.nodeName2, this.nodeName1, this.nodeName3});
    }
}

