/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.qom.AbstractQOMTest;

public class NodeLocalNameTest
extends AbstractQOMTest {
    private Node node1;
    private String nodeLocalName;

    protected void setUp() throws Exception {
        super.setUp();
        this.node1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        int colon = this.nodeName1.indexOf(58);
        this.nodeLocalName = colon != -1 ? this.nodeName1.substring(colon + 1) : this.nodeName1;
    }

    protected void tearDown() throws Exception {
        this.node1 = null;
        super.tearDown();
    }

    public void testStringLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(this.nodeLocalName);
        QueryObjectModel q = this.createQuery("jcr.operator.equal.to", literal);
        this.checkResult(q.execute(), new Node[]{this.node1});
    }

    public void testStringLiteralInvalidName() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue("[" + this.nodeLocalName);
        QueryObjectModel q = this.createQuery("jcr.operator.equal.to", literal);
        this.checkResult(q.execute(), new Node[0]);
    }

    public void testBinaryLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(this.nodeLocalName, 2);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[]{this.node1});
    }

    public void testDateLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(Calendar.getInstance());
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testDoubleLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(Math.PI);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testDecimalLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(new BigDecimal(283));
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testLongLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(283L);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testBooleanLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(true);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testNameLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(this.nodeLocalName, 7);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[]{this.node1});
    }

    public void testPathLiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue(this.nodeLocalName, 8);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[]{this.node1});
        literal = this.superuser.getValueFactory().createValue(this.node1.getPath(), 8);
        qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
        literal = this.superuser.getValueFactory().createValue(this.nodeName1 + "/" + this.nodeName1, 8);
        qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testReferenceLiteral() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.node1, this.mixReferenceable);
        this.superuser.save();
        Value literal = this.superuser.getValueFactory().createValue(this.node1);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testWeakReferenceLiteral() throws RepositoryException, NotExecutableException {
        this.ensureMixinType(this.node1, this.mixReferenceable);
        this.superuser.save();
        Value literal = this.superuser.getValueFactory().createValue(this.node1, true);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testURILiteral() throws RepositoryException {
        Value literal = this.superuser.getValueFactory().createValue("http://example.com", 11);
        QueryObjectModel qom = this.createQuery("jcr.operator.equal.to", literal);
        this.checkQOM(qom, new Node[0]);
    }

    public void testEqualTo() throws RepositoryException {
        this.checkOperator("jcr.operator.equal.to", false, true, false);
    }

    public void testGreaterThan() throws RepositoryException {
        this.checkOperator("jcr.operator.greater.than", true, false, false);
    }

    public void testGreaterThanOrEqualTo() throws RepositoryException {
        this.checkOperator("jcr.operator.greater.than.or.equal.to", true, true, false);
    }

    public void testLessThan() throws RepositoryException {
        this.checkOperator("jcr.operator.less.than", false, false, true);
    }

    public void testLessThanOrEqualTo() throws RepositoryException {
        this.checkOperator("jcr.operator.less.than.or.equal.to", false, true, true);
    }

    public void testLike() throws RepositoryException {
        this.checkOperator("jcr.operator.like", false, true, false);
    }

    public void testNotEqualTo() throws RepositoryException {
        this.checkOperator("jcr.operator.not.equal.to", true, false, true);
    }

    private void checkOperator(String operator, boolean matchesLesser, boolean matchesEqual, boolean matchesGreater) throws RepositoryException {
        this.checkOperatorSingleLiteral(this.createLexicographicallyLesser(this.nodeLocalName), operator, matchesLesser);
        this.checkOperatorSingleLiteral(this.nodeLocalName, operator, matchesEqual);
        this.checkOperatorSingleLiteral(this.createLexicographicallyGreater(this.nodeLocalName), operator, matchesGreater);
    }

    private void checkOperatorSingleLiteral(String literal, String operator, boolean matches) throws RepositoryException {
        Node[] nodeArray;
        Value value = this.superuser.getValueFactory().createValue(literal);
        QueryObjectModel qom = this.createQuery(operator, value);
        if (matches) {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = this.node1;
        } else {
            nodeArray = new Node[]{};
        }
        this.checkQOM(qom, nodeArray);
    }

    private String createLexicographicallyGreater(String name) {
        StringBuffer tmp = new StringBuffer(name);
        tmp.setCharAt(tmp.length() - 1, (char)(tmp.charAt(tmp.length() - 1) + '\u0001'));
        return tmp.toString();
    }

    private String createLexicographicallyLesser(String name) {
        StringBuffer tmp = new StringBuffer(name);
        tmp.setCharAt(tmp.length() - 1, (char)(tmp.charAt(tmp.length() - 1) - '\u0001'));
        return tmp.toString();
    }

    private QueryObjectModel createQuery(String operator, Value literal) throws RepositoryException {
        return this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.and((Constraint)this.qf.childNode("s", this.testRoot), (Constraint)this.qf.comparison((DynamicOperand)this.qf.nodeLocalName("s"), operator, (StaticOperand)this.qf.literal(literal))), null, null);
    }
}

