/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.retention;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.retention.Hold;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.retention.AbstractRetentionTest;

public class HoldEffectTest
extends AbstractRetentionTest {
    private Node childN;
    private Property childP;
    private Session otherS;

    protected void setUp() throws Exception {
        super.setUp();
        this.childN = this.testRootNode.addNode(this.nodeName2);
        Value v = this.getJcrValue(this.superuser, "propertyvalue1", "propertytype1", "test");
        this.childP = this.testRootNode.setProperty(this.propertyName1, v);
        this.superuser.save();
        this.otherS = this.getHelper().getSuperuserSession();
    }

    protected void tearDown() throws Exception {
        if (this.otherS != null) {
            this.otherS.logout();
        }
        Hold[] holds = this.retentionMgr.getHolds(this.testNodePath);
        for (int i = 0; i < holds.length; ++i) {
            this.retentionMgr.removeHold(this.testNodePath, holds[i]);
        }
        this.superuser.save();
        super.tearDown();
    }

    public void testTransientShallowHold() throws RepositoryException, NotExecutableException {
        this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        this.assertNoEffect(this.testRootNode, this.nodeName3, this.propertyName2);
        this.assertNoEffect(this.childN, this.nodeName3, this.propertyName2);
        this.assertNoEffect(this.childP);
    }

    public void testTransientShallowHoldForOtherSession() throws RepositoryException, NotExecutableException {
        this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        this.assertNoEffect((Node)this.otherS.getItem(this.testNodePath), this.nodeName3, this.propertyName2);
        this.assertNoEffect((Node)this.otherS.getItem(this.childN.getPath()), this.nodeName3, this.propertyName2);
        this.assertNoEffect((Property)this.otherS.getItem(this.childP.getPath()));
    }

    public void testTransientDeepHold() throws RepositoryException, NotExecutableException {
        this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
        this.assertNoEffect(this.testRootNode, this.nodeName3, this.propertyName2);
        this.assertNoEffect(this.childN, this.nodeName3, this.propertyName2);
        this.assertNoEffect(this.childP);
    }

    public void testTransientDeepHoldForOtherSession() throws RepositoryException, NotExecutableException {
        this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
        this.assertNoEffect((Node)this.otherS.getItem(this.testNodePath), this.nodeName3, this.propertyName2);
        this.assertNoEffect((Node)this.otherS.getItem(this.childN.getPath()), this.nodeName3, this.propertyName2);
        this.assertNoEffect((Property)this.otherS.getItem(this.childP.getPath()));
    }

    public void testShallowHold() throws RepositoryException, NotExecutableException {
        this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        this.superuser.save();
        this.assertNoEffect(this.childN, this.nodeName3, this.propertyName2);
        this.assertEffect(this.testRootNode, this.childN.getName(), this.childP.getName(), this.nodeName3, this.propertyName2);
    }

    public void testShallowHoldForOtherSession() throws RepositoryException, NotExecutableException {
        this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), false);
        this.superuser.save();
        this.assertNoEffect((Node)this.otherS.getItem(this.childN.getPath()), this.nodeName3, this.propertyName2);
        this.assertEffect((Node)this.otherS.getItem(this.testNodePath), this.childN.getName(), this.childP.getName(), this.nodeName3, this.propertyName2);
    }

    public void testDeepHold() throws RepositoryException, NotExecutableException {
        Node n = this.childN.addNode(this.nodeName2);
        Value v = this.getJcrValue(this.superuser, "propertyvalue1", "propertytype1", "test");
        Property p = this.childN.setProperty(this.propertyName1, v);
        this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
        this.superuser.save();
        this.assertEffect(this.testRootNode, this.childN.getName(), this.childP.getName(), this.nodeName3, this.propertyName2);
        this.assertEffect(this.childN, n.getName(), p.getName(), this.nodeName3, this.propertyName2);
    }

    public void testDeepHoldForOtherSession() throws RepositoryException, NotExecutableException {
        Node n = this.childN.addNode(this.nodeName2);
        Value v = this.getJcrValue(this.superuser, "propertyvalue1", "propertytype1", "test");
        Property p = this.childN.setProperty(this.propertyName1, v);
        this.retentionMgr.addHold(this.testNodePath, this.getHoldName(), true);
        this.superuser.save();
        this.assertEffect((Node)this.otherS.getItem(this.testNodePath), this.childN.getName(), this.childP.getName(), this.nodeName3, this.propertyName2);
        this.assertEffect((Node)this.otherS.getItem(this.childN.getPath()), n.getName(), p.getName(), this.nodeName3, this.propertyName2);
    }

    private void assertEffect(Node targetNode, String childName, String propName, String childName2, String propName2) throws RepositoryException {
        Property p;
        Session s = targetNode.getSession();
        try {
            Node child = targetNode.getNode(childName);
            child.remove();
            s.save();
            HoldEffectTest.fail((String)"Hold present must prevent a child node from being removed.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            p = targetNode.getProperty(propName);
            p.remove();
            s.save();
            HoldEffectTest.fail((String)"Hold present must prevent a child property from being removed.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            p = targetNode.getProperty(propName);
            p.setValue("test2");
            s.save();
            HoldEffectTest.fail((String)"Hold present must prevent the child property from being modified.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            targetNode.addNode(childName2);
            s.save();
            HoldEffectTest.fail((String)"Hold present must prevent the target node from having new nodes added.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        try {
            Value v = this.getJcrValue(s, "propertyvalue2", "propertytype2", "test");
            targetNode.setProperty(propName2, v);
            s.save();
            HoldEffectTest.fail((String)"Hold present must prevent the target node from having new properties set.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
        NodeType[] mixins = targetNode.getMixinNodeTypes();
        if (mixins.length > 0) {
            try {
                targetNode.removeMixin(mixins[0].getName());
                s.save();
                HoldEffectTest.fail((String)"Hold present must prevent the target node from having it's mixin types changed.");
            }
            catch (RepositoryException e) {
                s.refresh(false);
            }
        }
        try {
            targetNode.remove();
            s.save();
            HoldEffectTest.fail((String)"Hold present must prevent the target node from being removed.");
        }
        catch (RepositoryException e) {
            s.refresh(false);
        }
    }

    private void assertNoEffect(Node target, String childName, String propName) throws RepositoryException {
        Session s = target.getSession();
        Node n = target.addNode(childName);
        Value v = this.getJcrValue(s, "propertyvalue2", "propertytype2", "test");
        Property p = target.setProperty(propName, v);
        n.remove();
        p.remove();
    }

    private void assertNoEffect(Property target) throws RepositoryException {
        Session s = target.getSession();
        target.setValue("test3");
        target.remove();
    }
}

