/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class GetPredecessorsTest
extends AbstractVersionTest {
    public void testGetPredecessors() throws RepositoryException {
        this.versionableNode.checkout();
        Version version = this.versionableNode.checkin();
        GetPredecessorsTest.assertTrue((String)"Version should have at minimum one predecessor version.", (version.getPredecessors().length > 0 ? 1 : 0) != 0);
    }

    public void testGetLinearPredecessorSuccessor() throws RepositoryException {
        String path = this.versionableNode.getPath();
        VersionManager vm = this.versionableNode.getSession().getWorkspace().getVersionManager();
        Version pred = vm.getBaseVersion(path);
        GetPredecessorsTest.assertNull((Object)pred.getLinearSuccessor());
        Version root = vm.getVersionHistory(path).getRootVersion();
        GetPredecessorsTest.assertNull((Object)root.getLinearSuccessor());
        vm.checkout(path);
        Version version = vm.checkin(path);
        pred = (Version)this.versionableNode.getSession().getNode(pred.getPath());
        GetPredecessorsTest.assertTrue((String)"linear predecessor of new version should be previous version", (boolean)version.getLinearPredecessor().isSame((Item)pred));
        GetPredecessorsTest.assertTrue((String)"linear successor of previous version should be new version", (boolean)pred.getLinearSuccessor().isSame((Item)version));
    }
}

