/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class VersionLabelTest
extends AbstractVersionTest {
    protected String versionLabel = "foo";
    protected String versionLabel2 = "bar";
    protected VersionHistory vHistory;
    protected Version rootVersion;
    protected String jcrVersionLabels;

    protected void setUp() throws Exception {
        super.setUp();
        this.jcrVersionLabels = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":versionLabels";
        this.vHistory = this.versionableNode.getSession().getWorkspace().getVersionManager().getVersionHistory(this.versionableNode.getPath());
        this.rootVersion = this.vHistory.getRootVersion();
        if (this.vHistory.hasVersionLabel(this.versionLabel)) {
            VersionLabelTest.fail((String)("Version label '" + this.versionLabel + "' is already present in this version history. Label test cannot be performed."));
        }
        if (this.vHistory.hasVersionLabel(this.versionLabel2)) {
            VersionLabelTest.fail((String)("Version label '" + this.versionLabel2 + "' is already present in this version history. Label test cannot be performed."));
        }
    }

    protected void tearDown() throws Exception {
        try {
            this.vHistory.removeVersionLabel(this.versionLabel);
            this.vHistory.removeVersionLabel(this.versionLabel2);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        this.vHistory = null;
        this.rootVersion = null;
        super.tearDown();
    }

    public void testAddVersionLabel() throws RepositoryException {
        int initialLength = this.vHistory.getVersionLabels().length;
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        String[] labels = this.vHistory.getVersionLabels();
        VersionLabelTest.assertEquals((String)"A version label that has been successfully added must increes the total number of version labels available in the history.", (int)(initialLength + 1), (int)labels.length);
    }

    public void testAddVersionLabel2() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        String[] labels = this.vHistory.getVersionLabels();
        boolean found = false;
        for (int i = 0; i < labels.length; ++i) {
            if (!labels[i].equals(this.versionLabel)) continue;
            found = true;
            break;
        }
        VersionLabelTest.assertTrue((String)"The version label that has been successfully added must be present in the array containing all labels.", (boolean)found);
    }

    public void testAddVersionCheckVersionLabelsNode() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        this.vHistory = this.versionableNode.getVersionHistory();
        Node versionLabelNode = this.vHistory.getNode(this.jcrVersionLabels);
        VersionLabelTest.assertTrue((String)("The version label that has been successfully added must be present in the node '" + this.jcrVersionLabels + "'."), (boolean)versionLabelNode.getProperty(this.versionLabel).getString().equals(this.rootVersion.getUUID()));
    }

    public void testAddVersionCheckVersionLabelsNodeJcr2() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        this.vHistory = this.versionableNode.getSession().getWorkspace().getVersionManager().getVersionHistory(this.versionableNode.getPath());
        Node versionLabelNode = this.vHistory.getNode(this.jcrVersionLabels);
        VersionLabelTest.assertTrue((String)("The version label that has been successfully added must be present in the node '" + this.jcrVersionLabels + "'."), (boolean)versionLabelNode.getProperty(this.versionLabel).getString().equals(this.rootVersion.getUUID()));
    }

    public void testHasVersionLabel() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        VersionLabelTest.assertTrue((String)"VersionHistory.hasVersionLabel(String) must return true if the label has been sucessfully added.", (boolean)this.vHistory.hasVersionLabel(this.versionLabel));
    }

    public void testHasVersionLabelForVersion() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        VersionLabelTest.assertTrue((String)"VersionHistory.hasVersionLabel(Version, String) must return true if the label has been sucessfully added.", (boolean)this.vHistory.hasVersionLabel(this.rootVersion, this.versionLabel));
    }

    public void testAddMultipleVersionLabels() throws RepositoryException {
        try {
            this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
            this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel2, false);
        }
        catch (VersionException e) {
            VersionLabelTest.fail((String)"Adding multiple distict version labels to a version must be allowed.");
        }
    }

    public void testAddDuplicateVersionLabel() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        try {
            this.versionableNode.checkout();
            Version v = this.versionableNode.checkin();
            this.vHistory.addVersionLabel(v.getName(), this.versionLabel, false);
            VersionLabelTest.fail((String)"Adding a version label that already exist in the version history must throw a VersionException.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testAddDuplicateVersionLabelJcr2() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        try {
            VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
            String path = this.versionableNode.getPath();
            versionManager.checkout(path);
            Version v = versionManager.checkin(path);
            this.vHistory.addVersionLabel(v.getName(), this.versionLabel, false);
            VersionLabelTest.fail((String)"Adding a version label that already exist in the version history must throw a VersionException.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testMoveLabel() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        try {
            this.versionableNode.checkout();
            Version v = this.versionableNode.checkin();
            this.vHistory.addVersionLabel(v.getName(), this.versionLabel, true);
            if (!this.vHistory.hasVersionLabel(v, this.versionLabel)) {
                VersionLabelTest.fail((String)"If 'moveLabel' is true, an existing version label must be moved to the indicated version.");
            }
        }
        catch (VersionException e) {
            VersionLabelTest.fail((String)"If 'moveLabel' is true, an existing version label must be moved to the indicated version.");
        }
    }

    public void testMoveLabelJcr2() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        try {
            VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
            String path = this.versionableNode.getPath();
            versionManager.checkout(path);
            Version v = versionManager.checkin(path);
            this.vHistory.addVersionLabel(v.getName(), this.versionLabel, true);
            if (!this.vHistory.hasVersionLabel(v, this.versionLabel)) {
                VersionLabelTest.fail((String)"If 'moveLabel' is true, an existing version label must be moved to the indicated version.");
            }
        }
        catch (VersionException e) {
            VersionLabelTest.fail((String)"If 'moveLabel' is true, an existing version label must be moved to the indicated version.");
        }
    }

    public void testRemoveNonExistingLabel() throws RepositoryException {
        if (this.vHistory.hasVersionLabel(this.versionLabel)) {
            VersionLabelTest.fail((String)("Testing the removal on a non-existing version label failed: '" + this.versionLabel + "' exists on version history."));
        }
        try {
            this.vHistory.removeVersionLabel(this.versionLabel);
            VersionLabelTest.fail((String)"VersionHistory.removeLabel(String) must throw a VersionException if the label does not exist.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRemoveLabel() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        this.vHistory.removeVersionLabel(this.versionLabel);
        VersionLabelTest.assertFalse((String)"VersionHistory.removeLabel(String) must remove the version label if it exists (has successfully been added before).", (boolean)this.vHistory.hasVersionLabel(this.versionLabel));
    }

    public void testGetVersionByLabel() throws RepositoryException {
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, true);
        Version v = this.vHistory.getVersionByLabel(this.versionLabel);
        VersionLabelTest.assertTrue((String)"VersionHistory.getVersionByLabel(String) must retrieve the particular version that was specified in addVersionLabel call.", (boolean)v.isSame((Item)this.rootVersion));
    }

    public void testGetVersionLabels() throws RepositoryException {
        HashSet<String> testLabels = new HashSet<String>(Arrays.asList(this.vHistory.getVersionLabels()));
        this.versionableNode.checkout();
        Version v = this.versionableNode.checkin();
        this.vHistory.addVersionLabel(v.getName(), this.versionLabel, false);
        testLabels.add(this.versionLabel);
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel2, false);
        testLabels.add(this.versionLabel2);
        String[] labels = this.vHistory.getVersionLabels();
        for (int i = 0; i < labels.length; ++i) {
            String l = labels[i];
            if (!testLabels.contains(l)) {
                VersionLabelTest.fail((String)"VersionHistory.getVersionLabels() must only return labels, that have been added to the history.");
            }
            testLabels.remove(l);
        }
        VersionLabelTest.assertTrue((String)"VersionHistory.getVersionLabels() must return all labels, that have been added to the history.", (boolean)testLabels.isEmpty());
    }

    public void testGetVersionLabelsJcr2() throws RepositoryException {
        HashSet<String> testLabels = new HashSet<String>(Arrays.asList(this.vHistory.getVersionLabels()));
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        versionManager.checkout(path);
        Version v = versionManager.checkin(path);
        this.vHistory.addVersionLabel(v.getName(), this.versionLabel, false);
        testLabels.add(this.versionLabel);
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel2, false);
        testLabels.add(this.versionLabel2);
        String[] labels = this.vHistory.getVersionLabels();
        for (int i = 0; i < labels.length; ++i) {
            String l = labels[i];
            if (!testLabels.contains(l)) {
                VersionLabelTest.fail((String)"VersionHistory.getVersionLabels() must only return labels, that have been added to the history.");
            }
            testLabels.remove(l);
        }
        VersionLabelTest.assertTrue((String)"VersionHistory.getVersionLabels() must return all labels, that have been added to the history.", (boolean)testLabels.isEmpty());
    }

    public void testGetVersionLabelsForVersion() throws RepositoryException {
        HashSet<String> testLabels = new HashSet<String>(Arrays.asList(this.vHistory.getVersionLabels(this.rootVersion)));
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        testLabels.add(this.versionLabel);
        this.versionableNode.checkout();
        Version v = this.versionableNode.checkin();
        this.vHistory.addVersionLabel(v.getName(), this.versionLabel2, false);
        String[] labels = this.vHistory.getVersionLabels(this.rootVersion);
        for (int i = 0; i < labels.length; ++i) {
            String l = labels[i];
            if (!testLabels.contains(l)) {
                VersionLabelTest.fail((String)"VersionHistory.getVersionLabels(Version) must only return labels, that have been added for this version.");
            }
            testLabels.remove(l);
        }
        VersionLabelTest.assertTrue((String)"VersionHistory.getVersionLabels(Version)  must return all labels, that have been added for this version.", (boolean)testLabels.isEmpty());
    }

    public void testGetVersionLabelsForVersionJcr2() throws RepositoryException {
        HashSet<String> testLabels = new HashSet<String>(Arrays.asList(this.vHistory.getVersionLabels(this.rootVersion)));
        this.vHistory.addVersionLabel(this.rootVersion.getName(), this.versionLabel, false);
        testLabels.add(this.versionLabel);
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        versionManager.checkout(path);
        Version v = versionManager.checkin(path);
        this.vHistory.addVersionLabel(v.getName(), this.versionLabel2, false);
        String[] labels = this.vHistory.getVersionLabels(this.rootVersion);
        for (int i = 0; i < labels.length; ++i) {
            String l = labels[i];
            if (!testLabels.contains(l)) {
                VersionLabelTest.fail((String)"VersionHistory.getVersionLabels(Version) must only return labels, that have been added for this version.");
            }
            testLabels.remove(l);
        }
        VersionLabelTest.assertTrue((String)"VersionHistory.getVersionLabels(Version)  must return all labels, that have been added for this version.", (boolean)testLabels.isEmpty());
    }

    public void testRestoreByLabelNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.restoreByLabel(this.versionLabel, true);
            VersionLabelTest.fail((String)"Node.restoreByLabel(String, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreByLabelNonVersionableNodeJcr2() throws RepositoryException {
        try {
            this.nonVersionableNode.getSession().getWorkspace().getVersionManager().restoreByLabel(this.nonVersionableNode.getPath(), this.versionLabel, true);
            VersionLabelTest.fail((String)"Node.restoreByLabel(String, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testGetVersionLabelsForInvalidVersion() throws Exception {
        Node versionableNode2 = this.createVersionableNode(this.testRootNode, this.nodeName2, this.versionableNodeType);
        Version invalidV = versionableNode2.checkin();
        try {
            this.vHistory.getVersionLabels(invalidV);
            VersionLabelTest.fail((String)"VersionHistory.getVersionLabels(Version) must throw a VersionException if the specified version is not in this version history");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }
}

