/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.header.LabelHeader;
import org.apache.jackrabbit.webdav.header.OverwriteHeader;
import org.apache.jackrabbit.webdav.header.TimeoutHeader;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.ordering.OrderPatch;
import org.apache.jackrabbit.webdav.ordering.Position;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.transaction.TransactionInfo;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.OptionsInfo;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WebdavRequestImpl
implements WebdavRequest,
DavConstants {
    private static Logger log = Logger.getLogger((Class)WebdavRequestImpl.class);
    private static final DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private final HttpServletRequest httpRequest;
    private final DavLocatorFactory factory;
    private final IfHeader ifHeader;
    private final String hrefPrefix;
    private DavSession session;
    private int propfindType = 1;
    private DavPropertyNameSet propfindProps;
    private DavPropertySet proppatchSet;
    private DavPropertyNameSet proppatchRemove;
    private List proppatchList;

    public WebdavRequestImpl(HttpServletRequest httpRequest, DavLocatorFactory factory) {
        this.httpRequest = httpRequest;
        this.factory = factory;
        this.ifHeader = new IfHeader(httpRequest);
        String host = this.getHeader("Host");
        String scheme = this.getScheme();
        this.hrefPrefix = scheme + "://" + host + this.getContextPath();
    }

    public void setDavSession(DavSession session) {
        this.session = session;
        if (session != null) {
            String lt = this.getLockToken();
            if (lt != null) {
                session.addLockToken(lt);
            }
            Iterator it = this.ifHeader.getAllTokens();
            while (it.hasNext()) {
                String ifHeaderToken = (String)it.next();
                session.addLockToken(ifHeaderToken);
            }
        }
    }

    public DavSession getDavSession() {
        return this.session;
    }

    public DavResourceLocator getRequestLocator() {
        String ctx;
        String path = this.getRequestURI();
        if (path.startsWith(ctx = this.getContextPath())) {
            path = path.substring(ctx.length());
        }
        return this.factory.createResourceLocator(this.hrefPrefix, path);
    }

    public DavResourceLocator getDestinationLocator() {
        String destination = this.httpRequest.getHeader("Destination");
        if (destination != null) {
            block5: {
                try {
                    URI uri = new URI(destination);
                    if (uri.getAuthority().equals(this.httpRequest.getHeader("Host"))) {
                        destination = uri.getRawPath();
                    }
                }
                catch (URISyntaxException e) {
                    log.debug((Object)("Destination is path is not a valid URI (" + e.getMessage() + "."));
                    int pos = destination.lastIndexOf(":");
                    if (pos <= 0) break block5;
                    destination = destination.substring(destination.indexOf("/", pos));
                    log.debug((Object)("Tried to retrieve resource destination path from invalid URI: " + destination));
                }
            }
            String contextPath = this.httpRequest.getContextPath();
            if (destination.startsWith(contextPath)) {
                destination = destination.substring(contextPath.length());
            }
        }
        return this.factory.createResourceLocator(this.hrefPrefix, destination);
    }

    public boolean isOverwrite() {
        return new OverwriteHeader(this.httpRequest).isOverwrite();
    }

    public int getDepth(int defaultValue) {
        return DepthHeader.parse(this.httpRequest, defaultValue).getDepth();
    }

    public int getDepth() {
        return this.getDepth(Integer.MAX_VALUE);
    }

    public long getTimeout() {
        return TimeoutHeader.parse(this.httpRequest, Integer.MIN_VALUE).getTimeout();
    }

    public String getLockToken() {
        return CodedUrlHeader.parse(this.httpRequest, "Lock-Token").getCodedUrl();
    }

    public Document getRequestDocument() throws DavException {
        Document requestDocument = null;
        if (this.httpRequest.getContentLength() == 0) {
            return requestDocument;
        }
        try {
            ServletInputStream in = this.httpRequest.getInputStream();
            if (in != null) {
                BufferedInputStream bin = new BufferedInputStream((InputStream)in);
                ((InputStream)bin).mark(1);
                boolean isEmpty = -1 == ((InputStream)bin).read();
                ((InputStream)bin).reset();
                if (!isEmpty) {
                    DocumentBuilder docBuilder = BUILDER_FACTORY.newDocumentBuilder();
                    requestDocument = docBuilder.parse(bin);
                }
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to build an XML Document from the request body: " + e.getMessage()));
            }
            throw new DavException(400);
        }
        catch (ParserConfigurationException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to build an XML Document from the request body: " + e.getMessage()));
            }
            throw new DavException(500);
        }
        catch (SAXException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to build an XML Document from the request body: " + e.getMessage()));
            }
            throw new DavException(400);
        }
        return requestDocument;
    }

    public int getPropFindType() throws DavException {
        if (this.propfindProps == null) {
            this.parsePropFindRequest();
        }
        return this.propfindType;
    }

    public DavPropertyNameSet getPropFindProperties() throws DavException {
        if (this.propfindProps == null) {
            this.parsePropFindRequest();
        }
        return this.propfindProps;
    }

    private void parsePropFindRequest() throws DavException {
        this.propfindProps = new DavPropertyNameSet();
        Document requestDocument = this.getRequestDocument();
        if (requestDocument == null) {
            return;
        }
        Element root = requestDocument.getDocumentElement();
        if (!"propfind".equals(root.getLocalName())) {
            log.info((Object)"PropFind-Request has no <profind> tag.");
            throw new DavException(400, "PropFind-Request has no <profind> tag.");
        }
        ElementIterator it = DomUtil.getChildren(root);
        while (it.hasNext()) {
            Element child = it.nextElement();
            String nodeName = child.getLocalName();
            if ("prop".equals(nodeName)) {
                this.propfindType = 0;
                this.propfindProps = new DavPropertyNameSet(child);
                break;
            }
            if ("propname".equals(nodeName)) {
                this.propfindType = 2;
                break;
            }
            if (!"allprop".equals(nodeName)) continue;
            this.propfindType = 1;
            break;
        }
    }

    public DavPropertySet getPropPatchSetProperties() throws DavException {
        if (this.proppatchSet == null) {
            this.parsePropPatchRequest();
        }
        return this.proppatchSet;
    }

    public DavPropertyNameSet getPropPatchRemoveProperties() throws DavException {
        if (this.proppatchRemove == null) {
            this.parsePropPatchRequest();
        }
        return this.proppatchRemove;
    }

    public List getPropPatchChangeList() throws DavException {
        if (this.proppatchList == null) {
            this.parsePropPatchRequest();
        }
        return this.proppatchList;
    }

    private void parsePropPatchRequest() throws DavException {
        this.proppatchSet = new DavPropertySet();
        this.proppatchRemove = new DavPropertyNameSet();
        this.proppatchList = new ArrayList();
        Document requestDocument = this.getRequestDocument();
        if (requestDocument == null) {
            throw new DavException(400, "Invalid request body.");
        }
        Element root = requestDocument.getDocumentElement();
        if (!DomUtil.matches(root, "propertyupdate", NAMESPACE)) {
            log.warn((Object)"PropPatch-Request has no <DAV:propertyupdate> tag.");
            throw new DavException(400, "PropPatch-Request has no <propertyupdate> tag.");
        }
        ElementIterator it = DomUtil.getChildren(root);
        while (it.hasNext()) {
            DefaultDavProperty davProp;
            ElementIterator properties;
            Element propEl;
            Element el = it.nextElement();
            if (DomUtil.matches(el, "set", NAMESPACE)) {
                propEl = DomUtil.getChildElement(el, "prop", NAMESPACE);
                if (propEl == null) continue;
                properties = DomUtil.getChildren(propEl);
                while (properties.hasNext()) {
                    davProp = DefaultDavProperty.createFromXml(properties.nextElement());
                    this.proppatchSet.add(davProp);
                    this.proppatchList.add(davProp);
                }
                continue;
            }
            if (DomUtil.matches(el, "remove", NAMESPACE)) {
                propEl = DomUtil.getChildElement(el, "prop", NAMESPACE);
                if (propEl == null) continue;
                properties = DomUtil.getChildren(propEl);
                while (properties.hasNext()) {
                    davProp = DefaultDavProperty.createFromXml(properties.nextElement());
                    this.proppatchSet.add(davProp);
                    this.proppatchList.add(davProp.getName());
                }
                continue;
            }
            log.debug((Object)("Unknown element in DAV:propertyupdate: " + el.getNodeName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LockInfo getLockInfo() throws DavException {
        boolean isDeep = this.getDepth(Integer.MAX_VALUE) == Integer.MAX_VALUE;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument == null) return new LockInfo(null, this.getTimeout(), isDeep);
        Element root = requestDocument.getDocumentElement();
        if (root.getLocalName().equals("lockinfo")) {
            return new LockInfo(root, this.getTimeout(), isDeep);
        }
        log.debug((Object)"Lock request body must start with a DAV:lockinfo element.");
        throw new DavException(400);
    }

    public boolean matchesIfHeader(DavResource resource) {
        if (!this.ifHeader.hasValue() || resource == null || !resource.hasLock(Type.WRITE, Scope.EXCLUSIVE)) {
            return true;
        }
        boolean isMatching = false;
        String lockToken = resource.getLock(Type.WRITE, Scope.EXCLUSIVE).getToken();
        if (lockToken != null) {
            isMatching = this.matchesIfHeader(resource.getHref(), lockToken, this.getStrongETag(resource));
        }
        return isMatching;
    }

    public boolean matchesIfHeader(String href, String token, String eTag) {
        return this.ifHeader.matches(href, token, WebdavRequestImpl.isStrongETag(eTag) ? eTag : "");
    }

    private String getStrongETag(DavResource resource) {
        String etag;
        DavProperty prop = resource.getProperty(DavPropertyName.GETETAG);
        if (prop != null && prop.getValue() != null && WebdavRequestImpl.isStrongETag(etag = prop.getValue().toString())) {
            return etag;
        }
        return "";
    }

    private static boolean isStrongETag(String eTag) {
        return eTag != null && eTag.length() > 0 && !eTag.startsWith("W\\");
    }

    public String getTransactionId() {
        return CodedUrlHeader.parse(this.httpRequest, "TransactionId").getCodedUrl();
    }

    public TransactionInfo getTransactionInfo() throws DavException {
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            return new TransactionInfo(requestDocument.getDocumentElement());
        }
        return null;
    }

    public String getSubscriptionId() {
        return CodedUrlHeader.parse(this.httpRequest, "SubscriptionId").getCodedUrl();
    }

    public SubscriptionInfo getSubscriptionInfo() throws DavException {
        Element root;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null && "subscriptioninfo".equals((root = requestDocument.getDocumentElement()).getLocalName())) {
            int depth = this.getDepth(0);
            return new SubscriptionInfo(root, this.getTimeout(), depth == Integer.MAX_VALUE);
        }
        return null;
    }

    public String getOrderingType() {
        return this.getHeader("Ordering-Type");
    }

    public Position getPosition() {
        String[] typeNSegment;
        String h = this.getHeader("Position");
        Position pos = null;
        if (h != null && (typeNSegment = h.split("\\s")).length == 2) {
            try {
                pos = new Position(typeNSegment[0], typeNSegment[1]);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Cannot parse Position header: " + e.getMessage()));
            }
        }
        return pos;
    }

    public OrderPatch getOrderPatch() throws DavException {
        OrderPatch op = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            Element root = requestDocument.getDocumentElement();
            op = OrderPatch.createFromXml(root);
        } else {
            log.error((Object)"Error while building xml document from ORDERPATH request body.");
        }
        return op;
    }

    public String getLabel() {
        LabelHeader label = LabelHeader.parse(this);
        if (label != null) {
            return label.getLabel();
        }
        return null;
    }

    public LabelInfo getLabelInfo() throws DavException {
        LabelInfo lInfo = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            Element root = requestDocument.getDocumentElement();
            int depth = this.getDepth(0);
            lInfo = new LabelInfo(root, depth);
        }
        return lInfo;
    }

    public MergeInfo getMergeInfo() throws DavException {
        MergeInfo mInfo = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            mInfo = new MergeInfo(requestDocument.getDocumentElement());
        }
        return mInfo;
    }

    public UpdateInfo getUpdateInfo() throws DavException {
        UpdateInfo uInfo = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            uInfo = new UpdateInfo(requestDocument.getDocumentElement());
        }
        return uInfo;
    }

    public ReportInfo getReportInfo() throws DavException {
        ReportInfo rInfo = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            rInfo = new ReportInfo(requestDocument.getDocumentElement(), this.getDepth(0));
        }
        return rInfo;
    }

    public OptionsInfo getOptionsInfo() throws DavException {
        OptionsInfo info = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            info = OptionsInfo.createFromXml(requestDocument.getDocumentElement());
        }
        return info;
    }

    public String getAuthType() {
        return this.httpRequest.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.httpRequest.getCookies();
    }

    public long getDateHeader(String s) {
        return this.httpRequest.getDateHeader(s);
    }

    public String getHeader(String s) {
        return this.httpRequest.getHeader(s);
    }

    public Enumeration getHeaders(String s) {
        return this.httpRequest.getHeaders(s);
    }

    public Enumeration getHeaderNames() {
        return this.httpRequest.getHeaderNames();
    }

    public int getIntHeader(String s) {
        return this.httpRequest.getIntHeader(s);
    }

    public String getMethod() {
        return this.httpRequest.getMethod();
    }

    public String getPathInfo() {
        return this.httpRequest.getPathInfo();
    }

    public String getPathTranslated() {
        return this.httpRequest.getPathTranslated();
    }

    public String getContextPath() {
        return this.httpRequest.getContextPath();
    }

    public String getQueryString() {
        return this.httpRequest.getQueryString();
    }

    public String getRemoteUser() {
        return this.httpRequest.getRemoteUser();
    }

    public boolean isUserInRole(String s) {
        return this.httpRequest.isUserInRole(s);
    }

    public Principal getUserPrincipal() {
        return this.httpRequest.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.httpRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.httpRequest.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.httpRequest.getRequestURL();
    }

    public String getServletPath() {
        return this.httpRequest.getServletPath();
    }

    public HttpSession getSession(boolean b) {
        return this.httpRequest.getSession(b);
    }

    public HttpSession getSession() {
        return this.httpRequest.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.httpRequest.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.httpRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.httpRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.httpRequest.isRequestedSessionIdFromUrl();
    }

    public Object getAttribute(String s) {
        return this.httpRequest.getAttribute(s);
    }

    public Enumeration getAttributeNames() {
        return this.httpRequest.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.httpRequest.getCharacterEncoding();
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.httpRequest.setCharacterEncoding(s);
    }

    public int getContentLength() {
        return this.httpRequest.getContentLength();
    }

    public String getContentType() {
        return this.httpRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.httpRequest.getInputStream();
    }

    public String getParameter(String s) {
        return this.httpRequest.getParameter(s);
    }

    public Enumeration getParameterNames() {
        return this.httpRequest.getParameterNames();
    }

    public String[] getParameterValues(String s) {
        return this.httpRequest.getParameterValues(s);
    }

    public Map getParameterMap() {
        return this.httpRequest.getParameterMap();
    }

    public String getProtocol() {
        return this.httpRequest.getProtocol();
    }

    public String getScheme() {
        return this.httpRequest.getScheme();
    }

    public String getServerName() {
        return this.httpRequest.getServerName();
    }

    public int getServerPort() {
        return this.httpRequest.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.httpRequest.getReader();
    }

    public String getRemoteAddr() {
        return this.httpRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.httpRequest.getRemoteHost();
    }

    public void setAttribute(String s, Object o) {
        this.httpRequest.setAttribute(s, o);
    }

    public void removeAttribute(String s) {
        this.httpRequest.removeAttribute(s);
    }

    public Locale getLocale() {
        return this.httpRequest.getLocale();
    }

    public Enumeration getLocales() {
        return this.httpRequest.getLocales();
    }

    public boolean isSecure() {
        return this.httpRequest.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.httpRequest.getRequestDispatcher(s);
    }

    public String getRealPath(String s) {
        return this.httpRequest.getRealPath(s);
    }

    static {
        BUILDER_FACTORY.setNamespaceAware(true);
        BUILDER_FACTORY.setIgnoringComments(true);
        BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
        BUILDER_FACTORY.setCoalescing(true);
    }
}

