/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.header;

import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.header.Header;
import org.apache.log4j.Logger;

public class OverwriteHeader
implements Header {
    private static Logger log = Logger.getLogger((Class)OverwriteHeader.class);
    public static final String OVERWRITE_TRUE = "T";
    public static final String OVERWRITE_FALSE = "F";
    private boolean doOverwrite;

    public OverwriteHeader(boolean doOverwrite) {
        this.doOverwrite = doOverwrite;
    }

    public OverwriteHeader(HttpServletRequest request) {
        String overwriteHeader = request.getHeader("Overwrite");
        if (overwriteHeader != null) {
            this.doOverwrite = overwriteHeader.equalsIgnoreCase(OVERWRITE_TRUE);
        }
    }

    public String getHeaderName() {
        return "Overwrite";
    }

    public String getHeaderValue() {
        return this.doOverwrite ? OVERWRITE_TRUE : OVERWRITE_FALSE;
    }

    public boolean isOverwrite() {
        return this.doOverwrite;
    }
}

