/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.io;

import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.log4j.Logger;

public class OutputContextImpl
implements OutputContext {
    private static Logger log = Logger.getLogger((Class)OutputContextImpl.class);
    private final HttpServletResponse response;
    private final OutputStream out;

    public OutputContextImpl(HttpServletResponse response, OutputStream out) {
        if (response == null) {
            throw new IllegalArgumentException("Response must not be null.");
        }
        this.response = response;
        this.out = out;
    }

    public boolean hasStream() {
        return this.out != null;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setContentLanguage(String contentLanguage) {
        if (contentLanguage != null) {
            this.response.setHeader("Content-Language", contentLanguage);
        }
    }

    public void setContentLength(long contentLength) {
        int length = Integer.parseInt(contentLength + "");
        if (length >= 0) {
            this.response.setContentLength(length);
        }
    }

    public void setContentType(String contentType) {
        if (contentType != null) {
            this.response.setContentType(contentType);
        }
    }

    public void setModificationTime(long modificationTime) {
        if (modificationTime >= 0L) {
            this.response.addDateHeader("Last-Modified", modificationTime);
        }
    }

    public void setETag(String etag) {
        if (etag != null) {
            this.response.setHeader("ETag", etag);
        }
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (propertyName != null && propertyValue != null) {
            this.response.setHeader(propertyName, propertyValue);
        }
    }
}

