/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockDiscovery
extends AbstractDavProperty {
    private List activeLocks = new ArrayList();

    public LockDiscovery() {
        super(DavPropertyName.LOCKDISCOVERY, false);
    }

    public LockDiscovery(ActiveLock lock) {
        super(DavPropertyName.LOCKDISCOVERY, false);
        this.addActiveLock(lock);
    }

    public LockDiscovery(ActiveLock[] locks) {
        super(DavPropertyName.LOCKDISCOVERY, false);
        for (int i = 0; i < locks.length; ++i) {
            this.addActiveLock(locks[i]);
        }
    }

    private void addActiveLock(ActiveLock lock) {
        if (lock != null) {
            this.activeLocks.add(lock);
        }
    }

    public Object getValue() {
        return this.activeLocks;
    }

    public Element toXml(Document document) {
        Element lockdiscovery = this.getName().toXml(document);
        Iterator it = this.activeLocks.iterator();
        while (it.hasNext()) {
            ActiveLock lock = (ActiveLock)it.next();
            lockdiscovery.appendChild(lock.toXml(document));
        }
        return lockdiscovery;
    }
}

