/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.search;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.search.SearchConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SearchInfo
implements SearchConstants,
XmlSerializable {
    private static Logger log = Logger.getLogger((Class)SearchInfo.class);
    private final String language;
    private final Namespace languageNamespace;
    private final String query;

    public SearchInfo(String language, Namespace languageNamespace, String query) {
        this.language = language;
        this.languageNamespace = languageNamespace;
        this.query = query;
    }

    public String getLanguageName() {
        return this.language;
    }

    public Namespace getLanguageNameSpace() {
        return this.languageNamespace;
    }

    public String getQuery() {
        return this.query;
    }

    public Element toXml(Document document) {
        Element sRequestElem = DomUtil.createElement(document, "searchrequest", NAMESPACE);
        DomUtil.addChildElement(sRequestElem, this.language, this.languageNamespace, this.query);
        return sRequestElem;
    }

    public static SearchInfo createFromXml(Element searchRequest) throws DavException {
        if (searchRequest == null || !"searchrequest".equals(searchRequest.getLocalName())) {
            log.warn((Object)"The root element must be 'searchrequest'.");
            throw new DavException(400);
        }
        Element first = DomUtil.getFirstChildElement(searchRequest);
        if (first != null) {
            return new SearchInfo(first.getLocalName(), DomUtil.getNamespace(first), DomUtil.getText(first));
        }
        log.warn((Object)"A single child element is expected with the 'DAV:searchrequest'.");
        throw new DavException(400);
    }
}

