/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedReportSetProperty
extends AbstractDavProperty {
    private static Logger log = Logger.getLogger((Class)SupportedReportSetProperty.class);
    private final HashSet reportTypes = new HashSet();

    public SupportedReportSetProperty() {
        super(DeltaVConstants.SUPPORTED_REPORT_SET, true);
    }

    public SupportedReportSetProperty(ReportType[] reportTypes) {
        super(DeltaVConstants.SUPPORTED_REPORT_SET, true);
        for (int i = 0; i < reportTypes.length; ++i) {
            this.addReportType(reportTypes[i]);
        }
    }

    public void addReportType(ReportType reportType) {
        this.reportTypes.add(reportType);
    }

    public boolean isSupportedReport(ReportInfo reqInfo) {
        Iterator it = this.reportTypes.iterator();
        while (it.hasNext()) {
            ReportType rt = (ReportType)it.next();
            if (!rt.isRequestedReportType(reqInfo)) continue;
            return true;
        }
        return false;
    }

    public Object getValue() {
        return this.reportTypes;
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        Iterator it = this.reportTypes.iterator();
        while (it.hasNext()) {
            Element sr = DomUtil.addChildElement(elem, "supported-report", DeltaVConstants.NAMESPACE);
            Element r = DomUtil.addChildElement(sr, "report", DeltaVConstants.NAMESPACE);
            r.appendChild(((ReportType)it.next()).toXml(document));
        }
        return elem;
    }
}

