/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.PropertyId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyItemIterator
implements NodeIterator,
PropertyIterator,
VersionIterator {
    private static Logger log = LoggerFactory.getLogger(LazyItemIterator.class);
    private static final long UNDEFINED_SIZE = -1L;
    private final ItemManager itemMgr;
    private final Iterator<? extends HierarchyEntry> iter;
    private long size;
    private int pos;
    private Item next;

    public LazyItemIterator(ItemManager itemMgr, Iterator<? extends HierarchyEntry> hierarchyEntryIterator) {
        this.itemMgr = itemMgr;
        this.iter = hierarchyEntryIterator;
        this.size = hierarchyEntryIterator instanceof RangeIterator ? ((RangeIterator)hierarchyEntryIterator).getSize() : -1L;
        this.pos = 0;
        this.next = this.prefetchNext();
    }

    public LazyItemIterator(ItemManager itemMgr, HierarchyManager hierarchyMgr, Iterator<? extends ItemId> itemIds) throws ItemNotFoundException, RepositoryException {
        this.itemMgr = itemMgr;
        ArrayList<NodeEntry> entries = new ArrayList<NodeEntry>();
        while (itemIds.hasNext()) {
            ItemId id = itemIds.next();
            HierarchyEntry entry = id.denotesNode() ? hierarchyMgr.getNodeEntry((NodeId)id) : hierarchyMgr.getPropertyEntry((PropertyId)id);
            entries.add((NodeEntry)entry);
        }
        this.iter = entries.iterator();
        this.size = entries.size();
        this.pos = 0;
        this.next = this.prefetchNext();
    }

    private Item prefetchNext() {
        Item nextItem = null;
        while (nextItem == null && this.iter.hasNext()) {
            HierarchyEntry entry = this.iter.next();
            try {
                nextItem = this.itemMgr.getItem(entry);
            }
            catch (RepositoryException e) {
                log.warn("Failed to fetch item " + entry.getName() + ", skipping.", (Object)e.getMessage());
                --this.size;
            }
        }
        return nextItem;
    }

    public Node nextNode() {
        return (Node)this.next();
    }

    public Property nextProperty() {
        return (Property)this.next();
    }

    public Version nextVersion() {
        return (Version)this.next();
    }

    public long getPosition() {
        return this.pos;
    }

    public long getSize() {
        return this.size;
    }

    public void skip(long skipNum) {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if (skipNum == 0L) {
            return;
        }
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        while (--skipNum > 0L) {
            ++this.pos;
            HierarchyEntry entry = this.iter.next();
            while (!this.itemMgr.itemExists(entry)) {
                log.debug("Ignoring nonexistent item " + entry);
                entry = this.iter.next();
            }
        }
        ++this.pos;
        this.next = this.prefetchNext();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Item item = this.next;
        ++this.pos;
        this.next = this.prefetchNext();
        return item;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

