/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkin
extends AbstractOperation {
    private static Logger log = LoggerFactory.getLogger(Checkin.class);
    private final NodeState nodeState;
    private final VersionManager mgr;
    private NodeId newVersionId;

    private Checkin(NodeState nodeState, VersionManager mgr) {
        this.nodeState = nodeState;
        this.mgr = mgr;
    }

    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        try {
            NodeEntry vhe = this.mgr.getVersionHistoryEntry(this.nodeState);
            if (vhe != null) {
                vhe.invalidate(true);
            }
        }
        catch (RepositoryException e) {
            log.debug("Failed to access Version history entry -> skip invalidation.", (Throwable)e);
        }
        Iterator<PropertyEntry> entries = ((NodeEntry)this.nodeState.getHierarchyEntry()).getPropertyEntries();
        while (entries.hasNext()) {
            PropertyEntry pe = entries.next();
            pe.invalidate(false);
        }
        this.nodeState.getHierarchyEntry().invalidate(false);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public void setNewVersionId(NodeId newVersionId) {
        this.newVersionId = newVersionId;
    }

    public NodeId getNewVersionId() {
        return this.newVersionId;
    }

    public static Checkin create(NodeState nodeState, VersionManager mgr) {
        return new Checkin(nodeState, mgr);
    }
}

