/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import java.util.NoSuchElementException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RangeIterator;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.query.ScoreNodeIterator;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIteratorImpl
implements ScoreNodeIterator {
    private static final Logger log = LoggerFactory.getLogger(NodeIteratorImpl.class);
    private final ItemManager itemMgr;
    private final HierarchyManager hierarchyMgr;
    private final RangeIterator rows;
    private int pos = -1;
    private int invalid = 0;
    private NodeId nextId;
    private Node next;
    private double nextScore;

    public NodeIteratorImpl(ItemManager itemMgr, HierarchyManager hierarchyMgr, QueryInfo queryInfo) {
        this.itemMgr = itemMgr;
        this.hierarchyMgr = hierarchyMgr;
        this.rows = queryInfo.getRows();
        this.fetchNext();
    }

    public double getScore() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextScore;
    }

    public Node nextNode() throws NoSuchElementException {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Node n = this.next;
        this.fetchNext();
        return n;
    }

    public void skip(long skipNum) throws NoSuchElementException {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if (skipNum != 0L) {
            this.rows.skip(skipNum - 1L);
            this.pos = (int)((long)this.pos + (skipNum - 1L));
            this.fetchNext();
        }
    }

    public long getSize() {
        if (this.rows.getSize() != -1L) {
            return this.rows.getSize() - (long)this.invalid;
        }
        return -1L;
    }

    public long getPosition() {
        return this.pos - this.invalid;
    }

    public Object next() throws NoSuchElementException {
        return this.nextNode();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private void fetchNext() {
        this.next = null;
        this.nextScore = 0.0;
        while (this.next == null && this.rows.hasNext()) {
            try {
                QueryResultRow row = (QueryResultRow)this.rows.next();
                this.nextId = row.getNodeId(null);
                Item tmp = this.itemMgr.getItem(this.hierarchyMgr.getNodeEntry(this.nextId));
                if (tmp.isNode()) {
                    this.next = (Node)tmp;
                    this.nextScore = row.getScore(null);
                    continue;
                }
                log.warn("Item with Id is not a Node: " + this.nextId);
                ++this.invalid;
                ++this.pos;
            }
            catch (Exception e) {
                log.warn("Exception retrieving Node with Id: " + this.nextId);
                ++this.invalid;
                ++this.pos;
            }
        }
        ++this.pos;
    }
}

