/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.spi.Name;

class BitsetENTCacheImpl
implements EffectiveNodeTypeCache {
    private static final int BPW = 64;
    private static final long[] OR_MASK = new long[64];
    private final TreeSet<EffectiveNodeTypeCache.Key> sortedKeys;
    private final HashMap<EffectiveNodeTypeCache.Key, EffectiveNodeType> aggregates;
    private final ConcurrentHashMap<Name, Integer> nameIndex = new ConcurrentHashMap();
    private Name[] names = new Name[1024];

    BitsetENTCacheImpl() {
        this.sortedKeys = new TreeSet();
        this.aggregates = new HashMap();
    }

    @Override
    public EffectiveNodeTypeCache.Key getKey(Name[] ntNames) {
        return new BitsetKey(ntNames, this.nameIndex.size() + ntNames.length);
    }

    @Override
    public void put(EffectiveNodeType ent) {
        this.put(this.getKey(ent.getMergedNodeTypes()), ent);
    }

    @Override
    public void put(EffectiveNodeTypeCache.Key key, EffectiveNodeType ent) {
        this.aggregates.put(key, ent);
        this.sortedKeys.add(key);
    }

    @Override
    public EffectiveNodeTypeCache.Key findBest(EffectiveNodeTypeCache.Key key) {
        if (this.contains(key)) {
            return key;
        }
        for (EffectiveNodeTypeCache.Key k : this.sortedKeys) {
            if (!key.contains(k)) continue;
            return k;
        }
        return null;
    }

    @Override
    public void invalidate(Name name) {
        ArrayList<EffectiveNodeTypeCache.Key> keys = new ArrayList<EffectiveNodeTypeCache.Key>(this.aggregates.keySet());
        for (EffectiveNodeTypeCache.Key k : keys) {
            EffectiveNodeType ent = this.get(k);
            if (!ent.includesNodeType(name)) continue;
            this.remove(k);
        }
    }

    @Override
    public boolean contains(EffectiveNodeTypeCache.Key key) {
        return this.aggregates.containsKey(key);
    }

    @Override
    public EffectiveNodeType get(EffectiveNodeTypeCache.Key key) {
        return this.aggregates.get(key);
    }

    @Override
    public void clear() {
        this.sortedKeys.clear();
        this.aggregates.clear();
        this.nameIndex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBitNumber(Name name) {
        Integer i = this.nameIndex.get(name);
        if (i == null) {
            ConcurrentHashMap<Name, Integer> concurrentHashMap = this.nameIndex;
            synchronized (concurrentHashMap) {
                i = this.nameIndex.get(name);
                if (i == null) {
                    int idx = this.nameIndex.size();
                    i = idx;
                    this.nameIndex.put(name, i);
                    if (idx >= this.names.length) {
                        Name[] newNames = new Name[this.names.length * 2];
                        System.arraycopy(this.names, 0, newNames, 0, this.names.length);
                        this.names = newNames;
                    }
                    this.names[idx] = name;
                }
            }
        }
        return i;
    }

    private Name getName(int n) {
        return this.names[n];
    }

    private EffectiveNodeType remove(EffectiveNodeTypeCache.Key key) {
        EffectiveNodeType removed = this.aggregates.remove(key);
        if (removed != null) {
            this.sortedKeys.remove(key);
        }
        return removed;
    }

    public Object clone() {
        BitsetENTCacheImpl clone = new BitsetENTCacheImpl();
        clone.sortedKeys.addAll(this.sortedKeys);
        clone.aggregates.putAll(this.aggregates);
        clone.names = new Name[this.names.length];
        System.arraycopy(this.names, 0, clone.names, 0, this.names.length);
        clone.nameIndex.putAll(this.nameIndex);
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EffectiveNodeTypeCache (" + super.toString() + ")\n");
        builder.append("EffectiveNodeTypes in cache:\n");
        for (EffectiveNodeTypeCache.Key k : this.sortedKeys) {
            builder.append(k);
            builder.append('\n');
        }
        return builder.toString();
    }

    static {
        for (int i = 0; i < 64; ++i) {
            BitsetENTCacheImpl.OR_MASK[i] = 1L << i;
        }
    }

    private class BitsetKey
    implements EffectiveNodeTypeCache.Key {
        private final Name[] names;
        private final long[] bits;
        private final int hashCode;

        public BitsetKey(Name[] names, int maxBit) {
            this.names = names;
            this.bits = new long[maxBit / 64 + 1];
            for (int i = 0; i < names.length; ++i) {
                int n = BitsetENTCacheImpl.this.getBitNumber(names[i]);
                int n2 = n / 64;
                this.bits[n2] = this.bits[n2] | OR_MASK[n % 64];
            }
            this.hashCode = this.calcHashCode();
        }

        private BitsetKey(long[] bits, int numBits) {
            this.bits = bits;
            this.names = new Name[numBits];
            int i = this.nextSetBit(0);
            int j = 0;
            while (i >= 0) {
                this.names[j++] = BitsetENTCacheImpl.this.getName(i);
                i = this.nextSetBit(i + 1);
            }
            this.hashCode = this.calcHashCode();
        }

        private int nextSetBit(int fromIndex) {
            int off = fromIndex % 64;
            for (int addr = fromIndex / 64; addr < this.bits.length; ++addr) {
                if (this.bits[addr] == 0L) continue;
                while (off < 64) {
                    if ((this.bits[addr] & OR_MASK[off]) != 0L) {
                        return addr * 64 + off;
                    }
                    ++off;
                }
                off = 0;
            }
            return -1;
        }

        private int bitCount(long val) {
            val -= (val & 0xAAAAAAAAAAAAAAAAL) >>> 1;
            val = (val & 0x3333333333333333L) + (val >>> 2 & 0x3333333333333333L);
            val = val + (val >>> 4) & 0xF0F0F0F0F0F0F0FL;
            val += val >>> 8;
            val += val >>> 16;
            return (int)val + (int)(val >>> 32) & 0xFF;
        }

        private int calcHashCode() {
            int addr;
            long h = 1234L;
            for (addr = this.bits.length - 1; addr >= 0 && this.bits[addr] == 0L; --addr) {
            }
            while (addr >= 0) {
                h ^= this.bits[addr] * (long)(addr + 1);
                --addr;
            }
            return (int)(h >> 32 ^ h);
        }

        @Override
        public Name[] getNames() {
            return this.names;
        }

        @Override
        public boolean contains(EffectiveNodeTypeCache.Key otherKey) {
            BitsetKey other = (BitsetKey)otherKey;
            int len = Math.max(this.bits.length, other.bits.length);
            for (int i = 0; i < len; ++i) {
                long w2;
                long w1 = i < this.bits.length ? this.bits[i] : 0L;
                long r = (w1 ^ 0xFFFFFFFFFFFFFFFFL) & (w2 = i < other.bits.length ? other.bits[i] : 0L);
                if (r == 0L) continue;
                return false;
            }
            return true;
        }

        @Override
        public EffectiveNodeTypeCache.Key subtract(EffectiveNodeTypeCache.Key otherKey) {
            BitsetKey other = (BitsetKey)otherKey;
            int len = Math.max(this.bits.length, other.bits.length);
            long[] newBits = new long[len];
            int numBits = 0;
            for (int i = 0; i < len; ++i) {
                long w1 = i < this.bits.length ? this.bits[i] : 0L;
                long w2 = i < other.bits.length ? other.bits[i] : 0L;
                newBits[i] = w1 & (w2 ^ 0xFFFFFFFFFFFFFFFFL);
                numBits += this.bitCount(newBits[i]);
            }
            return new BitsetKey(newBits, numBits);
        }

        @Override
        public int compareTo(EffectiveNodeTypeCache.Key other) {
            BitsetKey o = (BitsetKey)other;
            int res = o.names.length - this.names.length;
            if (res == 0) {
                for (int adr = Math.max(this.bits.length, o.bits.length) - 1; adr >= 0; --adr) {
                    long w2;
                    long w1 = adr < this.bits.length ? this.bits[adr] : 0L;
                    long l = w2 = adr < o.bits.length ? o.bits[adr] : 0L;
                    if (w1 == w2) continue;
                    long h1 = w1 >>> 32;
                    long h2 = w2 >>> 32;
                    if (h1 == h2) {
                        h1 = w1 & 0xFFFFL;
                        h2 = w2 & 0xFFFFL;
                    }
                    return Long.signum(h2 - h1);
                }
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BitsetKey) {
                BitsetKey o = (BitsetKey)obj;
                if (this.names.length != o.names.length) {
                    return false;
                }
                for (int adr = Math.max(this.bits.length, o.bits.length) - 1; adr >= 0; --adr) {
                    long w2;
                    long w1 = adr < this.bits.length ? this.bits[adr] : 0L;
                    long l = w2 = adr < o.bits.length ? o.bits[adr] : 0L;
                    if (w1 == w2) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("w=");
            buf.append(this.names.length);
            int i = this.nextSetBit(0);
            while (i >= 0) {
                buf.append(", ").append(i).append("=");
                buf.append(BitsetENTCacheImpl.this.getName(i));
                i = this.nextSetBit(i + 1);
            }
            return buf.toString();
        }
    }
}

