/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.util.NoSuchElementException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RangeIteratorDecorator;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2jcr.IdFactoryImpl;
import org.apache.jackrabbit.spi2jcr.QueryResultRowImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryInfoImpl
implements QueryInfo {
    private static final Logger log = LoggerFactory.getLogger(QueryInfoImpl.class);
    private final QueryResult result;
    private final IdFactoryImpl idFactory;
    private final NamePathResolver resolver;
    private final QValueFactory qValueFactory;
    private final String[] columnNames;
    private final String[] selectorNames;

    public QueryInfoImpl(QueryResult result, IdFactoryImpl idFactory, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        this.result = result;
        this.idFactory = idFactory;
        this.resolver = resolver;
        this.qValueFactory = qValueFactory;
        this.columnNames = result.getColumnNames();
        this.selectorNames = result.getSelectorNames();
    }

    public RangeIterator getRows() {
        try {
            return new RangeIteratorDecorator((RangeIterator)this.result.getRows()){

                public Object next() {
                    try {
                        return new QueryResultRowImpl((Row)super.next(), QueryInfoImpl.this.columnNames, QueryInfoImpl.this.selectorNames, QueryInfoImpl.this.idFactory, QueryInfoImpl.this.resolver, QueryInfoImpl.this.qValueFactory);
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception when creating QueryResultRowImpl: " + e.getMessage(), (Throwable)e);
                        throw new NoSuchElementException();
                    }
                }
            };
        }
        catch (RepositoryException e) {
            return RangeIteratorAdapter.EMPTY;
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getSelectorNames() {
        return this.selectorNames;
    }
}

