/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2jcr.IdFactoryImpl;

class QueryResultRowImpl
implements QueryResultRow {
    private final Map<String, NodeId> nodeIds = new HashMap<String, NodeId>();
    private final Map<String, Double> scores = new HashMap<String, Double>();
    private final QValue[] values;

    public QueryResultRowImpl(Row row, String[] columnNames, String[] selectorNames, IdFactoryImpl idFactory, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        this.values = new QValue[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            Value v = row.getValue(columnNames[i]);
            this.values[i] = v == null ? null : ValueFormat.getQValue((Value)v, (NamePathResolver)resolver, (QValueFactory)qValueFactory);
        }
        ArrayList<String> selNames = new ArrayList<String>();
        selNames.addAll(Arrays.asList(selectorNames));
        if (selNames.isEmpty()) {
            selNames.add(null);
        }
        for (String sn : selNames) {
            double score;
            Node n;
            if (sn == null) {
                n = row.getNode();
                score = row.getScore();
            } else {
                n = row.getNode(sn);
                score = row.getScore(sn);
            }
            NodeId id = null;
            if (n != null) {
                id = idFactory.fromJcrIdentifier(n.getIdentifier());
            }
            this.nodeIds.put(sn, id);
            this.scores.put(sn, score);
        }
    }

    public NodeId getNodeId(String selectorName) {
        if (this.nodeIds.containsKey(selectorName)) {
            return this.nodeIds.get(selectorName);
        }
        if (this.nodeIds.size() == 1) {
            return this.nodeIds.values().iterator().next();
        }
        throw new IllegalArgumentException(selectorName + " is not a valid selectorName");
    }

    public double getScore(String selectorName) {
        Double score;
        if (this.scores.containsKey(selectorName)) {
            score = this.scores.get(selectorName);
        } else if (this.scores.size() == 1) {
            score = this.scores.values().iterator().next();
        } else {
            throw new IllegalArgumentException(selectorName + " is not a valid selectorName");
        }
        if (score == null) {
            return Double.NaN;
        }
        return score;
    }

    public QValue[] getValues() {
        QValue[] vals = new QValue[this.values.length];
        System.arraycopy(this.values, 0, vals, 0, this.values.length);
        return vals;
    }
}

