/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.EventImpl;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;

class EventFactory {
    private final Session session;
    private final NamePathResolver resolver;
    private final IdFactory idFactory;
    private final QValueFactory qValueFactory;

    public EventFactory(Session session, NamePathResolver resolver, IdFactory idFactory, QValueFactory qValueFactory) {
        this.session = session;
        this.resolver = resolver;
        this.idFactory = idFactory;
        this.qValueFactory = qValueFactory;
    }

    public Event fromJCREvent(javax.jcr.observation.Event e) throws RepositoryException {
        NodeId itemId;
        Path p = e.getPath() != null ? this.resolver.getQPath(e.getPath()) : null;
        Path parent = p != null ? p.getAncestor(1) : null;
        int type = e.getType();
        NodeId parentId = parent != null ? this.idFactory.createNodeId((String)null, parent) : null;
        String identifier = e.getIdentifier();
        Node node = null;
        if (identifier != null) {
            itemId = this.idFactory.fromJcrIdentifier(e.getIdentifier());
            try {
                node = this.session.getItem(e.getPath()).getParent();
            }
            catch (RepositoryException repositoryException) {}
        } else {
            switch (type) {
                case 1: 
                case 32: {
                    node = this.session.getItem(e.getPath()).getParent();
                }
                case 2: {
                    itemId = this.idFactory.createNodeId((String)null, p);
                    break;
                }
                case 4: 
                case 16: {
                    node = this.session.getItem(e.getPath()).getParent();
                }
                case 8: {
                    itemId = this.idFactory.createPropertyId(parentId, p.getName());
                    break;
                }
                default: {
                    itemId = null;
                }
            }
        }
        Name nodeTypeName = null;
        Name[] mixinTypes = Name.EMPTY_ARRAY;
        if (node != null) {
            try {
                parentId = this.idFactory.createNodeId(node.getUUID(), null);
            }
            catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
                // empty catch block
            }
            nodeTypeName = this.resolver.getQName(node.getPrimaryNodeType().getName());
            mixinTypes = EventFactory.getNodeTypeNames(node.getMixinNodeTypes(), (NameResolver)this.resolver);
        }
        HashMap<Name, QValue> info = new HashMap<Name, QValue>();
        Map jcrInfo = e.getInfo();
        for (Map.Entry entry : jcrInfo.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Name name = this.resolver.getQName(key);
            if (value != null) {
                QValue v = ValueFormat.getQValue((String)value.toString(), (int)8, (NamePathResolver)this.resolver, (QValueFactory)this.qValueFactory);
                info.put(name, v);
                continue;
            }
            info.put(name, null);
        }
        return new EventImpl(e.getType(), p, (ItemId)itemId, parentId, nodeTypeName, mixinTypes, e.getUserID(), e.getUserData(), e.getDate(), info);
    }

    private static Name[] getNodeTypeNames(NodeType[] nt, NameResolver resolver) throws NameException, NamespaceException {
        Name[] names = new Name[nt.length];
        for (int i = 0; i < nt.length; ++i) {
            Name ntName;
            names[i] = ntName = resolver.getQName(nt[i].getName());
        }
        return names;
    }
}

