/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.AbstractIndex;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.IndexListener;
import org.apache.jackrabbit.core.query.lucene.IndexMigration;
import org.apache.jackrabbit.core.query.lucene.IndexingQueue;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;

class PersistentIndex
extends AbstractIndex {
    private final String name;
    private IndexListener listener;

    PersistentIndex(String name, File indexDir, Analyzer analyzer, Similarity similarity, DocNumberCache cache, IndexingQueue indexingQueue) throws IOException {
        super(analyzer, similarity, FSDirectory.getDirectory(indexDir, (LockFactory)new NativeFSLockFactory(indexDir)), cache, indexingQueue);
        this.name = name;
        if (this.isExisting()) {
            IndexMigration.migrate(this, indexDir);
        }
    }

    int removeDocument(Term idTerm) throws IOException {
        int num = super.removeDocument(idTerm);
        if (num > 0 && this.listener != null) {
            this.listener.documentDeleted(idTerm);
        }
        return num;
    }

    void mergeIndex(AbstractIndex index) throws IOException {
        index.commit();
        this.getIndexWriter().addIndexes(new Directory[]{index.getDirectory()});
        this.invalidateSharedReader();
    }

    void addIndexes(IndexReader[] readers) throws IOException {
        this.getIndexWriter().addIndexes(readers);
        this.getIndexWriter().optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyIndex(AbstractIndex index) throws IOException {
        index.commit(true);
        byte[] buffer = new byte[1024];
        Directory dir = index.getDirectory();
        Directory dest = this.getDirectory();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            IndexInput in = dir.openInput(files[i]);
            try {
                IndexOutput out = dest.createOutput(files[i]);
                try {
                    int num;
                    for (long remaining = in.length(); remaining > 0L; remaining -= (long)num) {
                        num = (int)Math.min(remaining, (long)buffer.length);
                        in.readBytes(buffer, 0, num);
                        out.writeBytes(buffer, num);
                    }
                    continue;
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(IndexListener listener) throws IOException {
        ReadOnlyIndexReader reader = this.getReadOnlyIndexReader();
        this.listener = listener;
        return reader;
    }

    synchronized void resetListener() {
        this.listener = null;
    }

    int getNumDocuments() throws IOException {
        return this.getIndexReader().numDocs();
    }

    String getName() {
        return this.name;
    }
}

