/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.version.Version;
import org.apache.jackrabbit.rmi.remote.RemoteItem;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;
import org.apache.jackrabbit.rmi.remote.RemoteLock;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteNodeDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.remote.RemoteVersion;
import org.apache.jackrabbit.rmi.remote.RemoteVersionHistory;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerItem;

public class ServerNode
extends ServerItem
implements RemoteNode {
    private Node node;

    public ServerNode(Node node, RemoteAdapterFactory factory) throws RemoteException {
        super(node, factory);
        this.node = node;
    }

    public RemoteNode addNode(String path) throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNode(this.node.addNode(path));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteNode addNode(String path, String type) throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNode(this.node.addNode(path, type));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteProperty getProperty(String path) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteProperty(this.node.getProperty(path));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteIterator getProperties() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemotePropertyIterator(this.node.getProperties());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteItem getPrimaryItem() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteItem(this.node.getPrimaryItem());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteIterator getProperties(String pattern) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemotePropertyIterator(this.node.getProperties(pattern));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteIterator getReferences() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemotePropertyIterator(this.node.getReferences());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public String getUUID() throws RepositoryException, RemoteException {
        try {
            return this.node.getUUID();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean hasNodes() throws RepositoryException, RemoteException {
        try {
            return this.node.hasNodes();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean hasProperties() throws RepositoryException, RemoteException {
        try {
            return this.node.hasProperties();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean hasProperty(String path) throws RepositoryException, RemoteException {
        try {
            return this.node.hasProperty(path);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteNodeType[] getMixinNodeTypes() throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNodeTypeArray(this.node.getMixinNodeTypes());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteNodeType getPrimaryNodeType() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeType(this.node.getPrimaryNodeType());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean isNodeType(String type) throws RepositoryException, RemoteException {
        try {
            return this.node.isNodeType(type);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteIterator getNodes() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeIterator(this.node.getNodes());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteIterator getNodes(String pattern) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeIterator(this.node.getNodes(pattern));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteNode getNode(String path) throws RepositoryException, RemoteException {
        try {
            return this.getRemoteNode(this.node.getNode(path));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean hasNode(String path) throws RepositoryException, RemoteException {
        try {
            return this.node.hasNode(path);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteProperty setProperty(String name, Value value) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteProperty(this.node.setProperty(name, value));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteProperty setProperty(String name, Value value, int type) throws RepositoryException, RemoteException {
        try {
            Property property = this.node.setProperty(name, value, type);
            if (property == null) {
                return null;
            }
            return this.getFactory().getRemoteProperty(property);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void addMixin(String name) throws RepositoryException, RemoteException {
        try {
            this.node.addMixin(name);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean canAddMixin(String name) throws RepositoryException, RemoteException {
        try {
            return this.node.canAddMixin(name);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void removeMixin(String name) throws RepositoryException, RemoteException {
        try {
            this.node.removeMixin(name);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void orderBefore(String src, String dst) throws RepositoryException, RemoteException {
        try {
            this.node.orderBefore(src, dst);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteProperty setProperty(String name, Value[] values) throws RepositoryException, RemoteException {
        try {
            Property property = this.node.setProperty(name, values);
            if (property == null) {
                return null;
            }
            return this.getFactory().getRemoteProperty(property);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteNodeDefinition getDefinition() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeDefinition(this.node.getDefinition());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion checkin() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.node.checkin());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void checkout() throws RepositoryException, RemoteException {
        try {
            this.node.checkout();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public String getCorrespondingNodePath(String workspace) throws RepositoryException, RemoteException {
        try {
            return this.node.getCorrespondingNodePath(workspace);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public int getIndex() throws RepositoryException, RemoteException {
        try {
            return this.node.getIndex();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteIterator merge(String workspace, boolean bestEffort) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeIterator(this.node.merge(workspace, bestEffort));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void cancelMerge(String versionUUID) throws RepositoryException, RemoteException {
        try {
            this.node.cancelMerge(this.getVersionByUUID(versionUUID));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void doneMerge(String versionUUID) throws RepositoryException, RemoteException {
        try {
            this.node.doneMerge(this.getVersionByUUID(versionUUID));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void restore(String version, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            this.node.restore(version, removeExisting);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void restoreByUUID(String versionUUID, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            this.node.restore(this.getVersionByUUID(versionUUID), removeExisting);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void restore(String versionUUID, String path, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            this.node.restore(this.getVersionByUUID(versionUUID), path, removeExisting);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void restoreByLabel(String label, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            this.node.restoreByLabel(label, removeExisting);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void update(String workspace) throws RepositoryException, RemoteException {
        try {
            this.node.update(workspace);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean holdsLock() throws RepositoryException, RemoteException {
        try {
            return this.node.holdsLock();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean isCheckedOut() throws RepositoryException, RemoteException {
        try {
            return this.node.isCheckedOut();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersionHistory getVersionHistory() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersionHistory(this.node.getVersionHistory());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteVersion getBaseVersion() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.node.getBaseVersion());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public boolean isLocked() throws RepositoryException, RemoteException {
        try {
            return this.node.isLocked();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteProperty setProperty(String name, Value[] values, int type) throws RepositoryException, RemoteException {
        try {
            Property property = this.node.setProperty(name, values, type);
            return this.getFactory().getRemoteProperty(property);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void unlock() throws RepositoryException, RemoteException {
        try {
            this.node.unlock();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteLock getLock() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteLock(this.node.getLock());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteLock lock(boolean isDeep, boolean isSessionScoped) throws RepositoryException, RemoteException {
        try {
            Lock lock = this.node.lock(isDeep, isSessionScoped);
            return this.getFactory().getRemoteLock(lock);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    protected Version getVersionByUUID(String versionUUID) throws RepositoryException {
        Session session = this.node.getSession();
        Node versionNode = session.getNodeByUUID(versionUUID);
        if (versionNode instanceof Version) {
            return (Version)versionNode;
        }
        throw new RepositoryException("Cannot find version " + versionUUID);
    }
}

