/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class CompositeConflictHandler
implements ThreeWayConflictHandler {
    private final LinkedList<ThreeWayConflictHandler> handlers;

    public CompositeConflictHandler(@Nonnull Iterable<ThreeWayConflictHandler> handlers) {
        this.handlers = Lists.newLinkedList((Iterable)((Iterable)Preconditions.checkNotNull(handlers)));
    }

    public CompositeConflictHandler() {
        this.handlers = Lists.newLinkedList();
    }

    public CompositeConflictHandler addHandler(ThreeWayConflictHandler handler) {
        this.handlers.addFirst(handler);
        return this;
    }

    @Override
    public ThreeWayConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.addExistingProperty(parent, ours, theirs);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.ADD_EXISTING_PROPERTY) + " conflict");
    }

    @Override
    public ThreeWayConflictHandler.Resolution changeDeletedProperty(NodeBuilder parent, PropertyState ours, PropertyState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.changeDeletedProperty(parent, ours, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_DELETED_PROPERTY) + " conflict");
    }

    @Override
    public ThreeWayConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs, PropertyState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.changeChangedProperty(parent, ours, theirs, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_CHANGED_PROPERTY) + " conflict");
    }

    @Override
    public ThreeWayConflictHandler.Resolution deleteDeletedProperty(NodeBuilder parent, PropertyState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.deleteDeletedProperty(parent, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_DELETED_PROPERTY) + " conflict");
    }

    @Override
    public ThreeWayConflictHandler.Resolution deleteChangedProperty(NodeBuilder parent, PropertyState theirs, PropertyState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.deleteChangedProperty(parent, theirs, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_CHANGED_PROPERTY) + " conflict");
    }

    @Override
    public ThreeWayConflictHandler.Resolution addExistingNode(NodeBuilder parent, String name, NodeState ours, NodeState theirs) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.addExistingNode(parent, name, ours, theirs);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.ADD_EXISTING_NODE) + " conflict");
    }

    @Override
    public ThreeWayConflictHandler.Resolution changeDeletedNode(NodeBuilder parent, String name, NodeState ours, NodeState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.changeDeletedNode(parent, name, ours, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.CHANGE_DELETED_NODE) + " conflict");
    }

    @Override
    public ThreeWayConflictHandler.Resolution deleteChangedNode(NodeBuilder parent, String name, NodeState theirs, NodeState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.deleteChangedNode(parent, name, theirs, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_CHANGED_NODE) + " conflict");
    }

    @Override
    public ThreeWayConflictHandler.Resolution deleteDeletedNode(NodeBuilder parent, String name, NodeState base) {
        for (ThreeWayConflictHandler handler : this.handlers) {
            ThreeWayConflictHandler.Resolution resolution = handler.deleteDeletedNode(parent, name, base);
            if (resolution == ThreeWayConflictHandler.Resolution.IGNORED) continue;
            return resolution;
        }
        throw new IllegalStateException("No conflict handler for " + (Object)((Object)ConflictType.DELETE_DELETED_NODE) + " conflict");
    }
}

