/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Set;
import org.jclouds.domain.JsonBall;

public class Attribute {
    private String required;
    private boolean calculated;
    private List<String> choice = Lists.newArrayList();
    @SerializedName(value="default")
    private JsonBall defaultValue;
    private String type;
    private List<String> recipes = Lists.newArrayList();
    @SerializedName(value="display_name")
    private String displayName;
    private String description;

    public Attribute(String required, boolean calculated, Set<String> choice, JsonBall defaultValue, String type, List<String> recipes, String displayName, String description) {
        this.required = required;
        this.calculated = calculated;
        Iterables.addAll(this.choice, choice);
        this.defaultValue = defaultValue;
        this.type = type;
        Iterables.addAll(this.recipes, recipes);
        this.displayName = displayName;
        this.description = description;
    }

    public Attribute() {
    }

    public String getRequired() {
        return this.required;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public List<String> getChoice() {
        return this.choice;
    }

    public JsonBall getDefaultValue() {
        return this.defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getRecipes() {
        return this.recipes;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.calculated ? 1231 : 1237);
        result = 31 * result + (this.choice == null ? 0 : ((Object)this.choice).hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.recipes == null ? 0 : ((Object)this.recipes).hashCode());
        result = 31 * result + (this.required == null ? 0 : this.required.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.calculated != other.calculated) {
            return false;
        }
        if (this.choice == null ? other.choice != null : !((Object)this.choice).equals(other.choice)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals((Object)other.defaultValue)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.recipes == null ? other.recipes != null : !((Object)this.recipes).equals(other.recipes)) {
            return false;
        }
        if (this.required == null ? other.required != null : !this.required.equals(other.required)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "Attribute [calculated=" + this.calculated + ", choice=" + this.choice + ", defaultValue=" + this.defaultValue + ", description=" + this.description + ", displayName=" + this.displayName + ", recipes=" + this.recipes + ", required=" + this.required + ", type=" + this.type + "]";
    }
}

