/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Set;

public class CookbookDefinition {
    private URI url;
    private Set<Version> versions = Sets.newLinkedHashSet();

    CookbookDefinition() {
    }

    public CookbookDefinition(URI url, Set<Version> versions) {
        this.url = url;
        this.versions = versions;
    }

    public URI getUrl() {
        return this.url;
    }

    public Set<Version> getVersions() {
        return this.versions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.versions == null ? 0 : ((Object)this.versions).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CookbookDefinition other = (CookbookDefinition)obj;
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.versions == null ? other.versions != null : !((Object)this.versions).equals(other.versions));
    }

    public String toString() {
        return "CookbookDefinition [url=" + this.url + ", versions=" + this.versions + "]";
    }

    public static class Version {
        private URI url;
        private String version;

        Version() {
        }

        public Version(URI url, String version) {
            this.url = url;
            this.version = version;
        }

        public URI getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public String toString() {
            return "Version [url=" + this.url + ", version=" + this.version + "]";
        }
    }
}

